/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import org.jcrom.AbstractLazyLoader;
import org.jcrom.Mapper;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;

class ChildNodeListLoader
extends AbstractLazyLoader {
    private static final Logger logger = Logger.getLogger(ChildNodeListLoader.class.getName());
    private final Class<?> objectClass;
    private final Object parentObject;
    private final String containerPath;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final JcrChildNode jcrChildNode;

    ChildNodeListLoader(Class<?> objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, JcrChildNode jcrChildNode) {
        super(session, mapper);
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.containerPath = containerPath;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
        this.jcrChildNode = jcrChildNode;
    }

    @Override
    protected Object doLoadObject(Session session, Mapper mapper) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading children list for " + this.containerPath);
        }
        Node childrenContainer = PathUtils.getNode(this.containerPath, session);
        return mapper.getChildNodeMapper().getChildrenList(this.objectClass, childrenContainer, this.parentObject, mapper, this.depth, this.nodeFilter, this.jcrChildNode);
    }
}

