/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import org.jcrom.AbstractLazyLoader;
import org.jcrom.Mapper;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;

class ChildNodeLoader
extends AbstractLazyLoader {
    private static final Logger logger = Logger.getLogger(ChildNodeLoader.class.getName());
    private final Class<?> objectClass;
    private final Object parentObject;
    private final String containerPath;
    private final int depth;
    private final NodeFilter nodeFilter;
    private final boolean pathIsContainer;

    ChildNodeLoader(Class<?> objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter) {
        this(objectClass, parentObject, containerPath, session, mapper, depth, nodeFilter, true);
    }

    ChildNodeLoader(Class<?> objectClass, Object parentObject, String containerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, boolean pathIsContainer) {
        super(session, mapper);
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.containerPath = containerPath;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
        this.pathIsContainer = pathIsContainer;
    }

    @Override
    protected Object doLoadObject(Session session, Mapper mapper) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading single child for " + this.containerPath);
        }
        Node node = this.pathIsContainer ? PathUtils.getNode(this.containerPath, session).getNodes().nextNode() : PathUtils.getNode(this.containerPath, session);
        return mapper.getChildNodeMapper().getSingleChild(this.objectClass, node, this.parentObject, mapper, this.depth, this.nodeFilter);
    }
}

