/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.jcrom.Mapper;
import org.jcrom.ProxyFactory;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.ReflectionUtils;

class ChildNodeMapper {
    private static final String POLICY_NODE_NAME = "rep:policy";
    private final Mapper mapper;

    public ChildNodeMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private String getNodeName(Field field) {
        JcrChildNode jcrChildNode = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrChildNode.class);
        String name = field.getName();
        if (!jcrChildNode.name().equals("fieldName")) {
            name = jcrChildNode.name();
        }
        return name;
    }

    private void removeChildren(Node containerNode) throws RepositoryException {
        NodeIterator nodeIterator = containerNode.getNodes();
        while (nodeIterator.hasNext()) {
            Node currentNode = nodeIterator.nextNode();
            if (currentNode.getName().equals(POLICY_NODE_NAME)) continue;
            currentNode.remove();
        }
    }

    private Node createChildNodeContainer(Node node, String containerName, JcrChildNode jcrChildNode, Mapper mapper) throws RepositoryException {
        if (!node.hasNode(mapper.getCleanName(containerName))) {
            Node containerNode = node.addNode(mapper.getCleanName(containerName), jcrChildNode.containerNodeType());
            if (jcrChildNode != null && jcrChildNode.containerMixinTypes() != null) {
                String[] stringArray = jcrChildNode.containerMixinTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String mixinType = stringArray[n2];
                    if (containerNode.canAddMixin(mixinType)) {
                        containerNode.addMixin(mixinType);
                    }
                    ++n2;
                }
            }
            return containerNode;
        }
        return node.getNode(mapper.getCleanName(containerName));
    }

    private void addSingleChildToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        if (jcrChildNode.createContainerNode()) {
            Node childContainer = this.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
            if (!childContainer.hasNodes()) {
                if (field.get(obj) != null) {
                    mapper.addNode(childContainer, field.get(obj), null);
                }
            } else if (field.get(obj) != null) {
                Object childObj = field.get(obj);
                mapper.updateNode(childContainer.getNodes().nextNode(), childObj, childObj.getClass(), nodeFilter, depth + 1);
            } else {
                this.removeChildren(childContainer);
            }
        } else if (!node.hasNode(nodeName)) {
            if (field.get(obj) != null) {
                Object childObj = field.get(obj);
                mapper.setNodeName(childObj, nodeName);
                mapper.addNode(node, childObj, null);
            }
        } else if (field.get(obj) != null) {
            Object childObj = field.get(obj);
            mapper.setNodeName(childObj, nodeName);
            mapper.updateNode(node.getNode(nodeName), childObj, childObj.getClass(), nodeFilter, depth + 1);
        } else {
            NodeIterator nodeIterator = node.getNodes(nodeName);
            while (nodeIterator.hasNext()) {
                nodeIterator.nextNode().remove();
            }
        }
    }

    private void addMultipleChildrenToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Node childContainer = this.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
        List children = (List)field.get(obj);
        if (children != null && !children.isEmpty()) {
            if (childContainer.hasNodes()) {
                NodeIterator childNodes = childContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    Object childEntity = mapper.findEntityByPath(children, child.getPath());
                    if (childEntity == null) {
                        child.remove();
                        continue;
                    }
                    mapper.updateNode(child, childEntity, childEntity.getClass(), nodeFilter, depth + 1);
                }
                int i = 0;
                while (i < children.size()) {
                    Object child = children.get(i);
                    String childPath = mapper.getNodePath(child);
                    if (childPath == null || childPath.equals("") || !childContainer.hasNode(mapper.getCleanName(mapper.getNodeName(child)))) {
                        mapper.addNode(childContainer, child, null);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < children.size()) {
                    mapper.addNode(childContainer, children.get(i), null);
                    ++i;
                }
            }
        } else {
            this.removeChildren(childContainer);
        }
    }

    private void addMapOfChildrenToNode(Field field, JcrChildNode jcrChildNode, Object obj, String nodeName, Node node, Mapper mapper, int depth, NodeFilter nodeFilter) throws IllegalAccessException, RepositoryException, IOException {
        Node childContainer = this.createChildNodeContainer(node, nodeName, jcrChildNode, mapper);
        Map childMap = (Map)field.get(obj);
        if (childMap != null && !childMap.isEmpty()) {
            Class<?> paramClass = ReflectionUtils.getParameterizedClass(field, 1);
            if (childContainer.hasNodes()) {
                HashMap<String, String> mapWithCleanKeys = new HashMap<String, String>();
                for (Map.Entry entry : childMap.entrySet()) {
                    String key = (String)entry.getKey();
                    String cleanKey = mapper.getCleanName(key);
                    if (childContainer.hasNode(cleanKey)) {
                        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
                            childContainer.getNode(cleanKey).remove();
                            Node listContainer = childContainer.addNode(cleanKey);
                            List childList = (List)entry.getValue();
                            int i = 0;
                            while (i < childList.size()) {
                                mapper.addNode(listContainer, childList.get(i), null);
                                ++i;
                            }
                        } else {
                            mapper.updateNode(childContainer.getNode(cleanKey), entry.getValue(), paramClass, nodeFilter, depth + 1);
                        }
                    } else {
                        this.addMapChild(paramClass, childContainer, childMap, key, cleanKey, mapper);
                    }
                    mapWithCleanKeys.put(cleanKey, "1");
                }
                NodeIterator childNodes = childContainer.getNodes();
                while (childNodes.hasNext()) {
                    Node child = childNodes.nextNode();
                    if (mapWithCleanKeys.containsKey(child.getName())) continue;
                    child.remove();
                }
            } else {
                for (Object k : childMap.keySet()) {
                    String key = (String)k;
                    String cleanKey = mapper.getCleanName(key);
                    this.addMapChild(paramClass, childContainer, childMap, key, cleanKey, mapper);
                }
            }
        } else {
            this.removeChildren(childContainer);
        }
    }

    private void addMapChild(Class<?> paramClass, Node childContainer, Map<?, ?> childMap, String key, String cleanKey, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        if (ReflectionUtils.implementsInterface(paramClass, List.class)) {
            List childList = (List)childMap.get(key);
            Node listContainer = childContainer.addNode(cleanKey);
            int i = 0;
            while (i < childList.size()) {
                mapper.addNode(listContainer, childList.get(i), null);
                ++i;
            }
        } else {
            mapper.setNodeName(childMap.get(key), cleanKey);
            mapper.addNode(childContainer, childMap.get(key), null);
        }
    }

    private void setChildren(Field field, Object obj, Node node, int depth, NodeFilter nodeFilter, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        JcrChildNode jcrChildNode = mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrChildNode.class);
        String nodeName = this.getNodeName(field);
        if (nodeFilter == null || nodeFilter.isIncluded(field.getName(), depth)) {
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                this.addMultipleChildrenToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                this.addMapOfChildrenToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            } else {
                this.addSingleChildToNode(field, jcrChildNode, obj, nodeName, node, mapper, depth, nodeFilter);
            }
        }
    }

    void addChildren(Field field, Object entity, Node node, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        this.setChildren(field, entity, node, -1, null, mapper);
    }

    void updateChildren(Field field, Object obj, Node node, int depth, NodeFilter nodeFilter, Mapper mapper) throws IllegalAccessException, RepositoryException, IOException {
        this.setChildren(field, obj, node, depth, nodeFilter, mapper);
    }

    List<?> getChildrenList(Class<?> childObjClass, Node childrenContainer, Object parentObj, Mapper mapper, int depth, NodeFilter nodeFilter, JcrChildNode jcrChildNode) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        List children = jcrChildNode.listContainerClass().newInstance();
        NodeIterator iterator = childrenContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            if (childNode.getName().equals(POLICY_NODE_NAME)) continue;
            children.add(this.getSingleChild(childObjClass, childNode, parentObj, mapper, depth, nodeFilter));
        }
        return children;
    }

    private Map<?, ?> getChildrenMap(Class<?> mapParamClass, Node childrenContainer, Object parentObj, Mapper mapper, int depth, NodeFilter nodeFilter, JcrChildNode jcrChildNode) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        Map children = jcrChildNode.mapContainerClass().newInstance();
        NodeIterator iterator = childrenContainer.getNodes();
        while (iterator.hasNext()) {
            Node childNode = iterator.nextNode();
            if (ReflectionUtils.implementsInterface(mapParamClass, List.class)) {
                if (jcrChildNode.lazy()) {
                    children.put(childNode.getName(), ProxyFactory.createChildNodeListProxy(Object.class, parentObj, childNode.getPath(), childNode.getSession(), mapper, depth, nodeFilter, jcrChildNode));
                    continue;
                }
                children.put(childNode.getName(), this.getChildrenList(Object.class, childNode, parentObj, mapper, depth, nodeFilter, jcrChildNode));
                continue;
            }
            if (jcrChildNode.lazy()) {
                children.put(childNode.getName(), ProxyFactory.createChildNodeProxy(mapper.findClassFromNode(Object.class, childNode), parentObj, childNode.getPath(), childNode.getSession(), mapper, depth, nodeFilter, false));
                continue;
            }
            children.put(childNode.getName(), this.getSingleChild(Object.class, childNode, parentObj, mapper, depth, nodeFilter));
        }
        return children;
    }

    Object getSingleChild(Class<?> childObjClass, Node childNode, Object obj, Mapper mapper, int depth, NodeFilter nodeFilter) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        childNode = mapper.checkIfVersionedChild(childNode);
        Object childObj = mapper.createInstanceForNode(childObjClass, childNode);
        childObj = mapper.mapNodeToClass(childObj, childNode, nodeFilter, obj, depth + 1);
        return childObj;
    }

    void getChildrenFromNode(Field field, Node node, Object obj, int depth, NodeFilter nodeFilter, Mapper mapper) throws ClassNotFoundException, InstantiationException, RepositoryException, IllegalAccessException, IOException {
        boolean childHasNodes;
        String nodeName = this.getNodeName(field);
        JcrChildNode jcrChildNode = mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrChildNode.class);
        boolean bl = childHasNodes = node.hasNode(nodeName) && (node.getNode(nodeName).hasNodes() || node.getNode(nodeName).hasProperty("{http://www.jcp.org/jcr/1.0}childVersionHistory"));
        if (node.hasNode(nodeName) && (childHasNodes || !jcrChildNode.createContainerNode() && !ReflectionUtils.implementsInterface(field.getType(), List.class) && !ReflectionUtils.implementsInterface(field.getType(), Map.class)) && nodeFilter.isIncluded(field.getName(), depth)) {
            Node childrenContainer = node.getNode(nodeName);
            childrenContainer = mapper.checkIfVersionedChild(childrenContainer);
            if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                Class<?> childObjClass = ReflectionUtils.getParameterizedClass(field);
                List<?> children = jcrChildNode.lazy() ? ProxyFactory.createChildNodeListProxy(childObjClass, obj, childrenContainer.getPath(), node.getSession(), mapper, depth, nodeFilter, jcrChildNode) : this.getChildrenList(childObjClass, childrenContainer, obj, mapper, depth, nodeFilter, jcrChildNode);
                field.set(obj, children);
            } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                Class<?> mapParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                field.set(obj, this.getChildrenMap(mapParamClass, childrenContainer, obj, mapper, depth, nodeFilter, jcrChildNode));
            } else {
                Class<?> childObjClass = field.getType();
                if (childrenContainer.hasNodes() || !jcrChildNode.createContainerNode()) {
                    if (jcrChildNode.lazy()) {
                        field.set(obj, ProxyFactory.createChildNodeProxy(childObjClass, obj, childrenContainer.getPath(), node.getSession(), mapper, depth, nodeFilter, jcrChildNode.createContainerNode()));
                    } else if (jcrChildNode.createContainerNode()) {
                        field.set(obj, this.getSingleChild(childObjClass, childrenContainer.getNodes().nextNode(), obj, mapper, depth, nodeFilter));
                    } else {
                        field.set(obj, this.getSingleChild(childObjClass, childrenContainer, obj, mapper, depth, nodeFilter));
                    }
                }
            }
        }
    }

    String getChildContainerNodePath(Object childObject, Object parentObject, Node parentNode) throws IllegalAccessException, RepositoryException {
        List<String> childContainerPaths = this.getChildContainerNodePaths(childObject, parentObject, parentNode);
        if (childContainerPaths.size() > 1) {
            throw new IllegalAccessException("Multiple child objects found with type '" + childObject.getClass() + "' from parent object '" + parentObject.getClass() + "'");
        }
        return childContainerPaths.isEmpty() ? null : childContainerPaths.get(0);
    }

    List<String> getChildContainerNodePaths(Object childObject, Object parentObject, Node parentNode) throws IllegalAccessException, RepositoryException {
        Class<?> type = childObject.getClass();
        String childNodeName = this.mapper.getNodeName(childObject);
        ArrayList<String> containers = new ArrayList<String>();
        ArrayList<String> children = new ArrayList<String>();
        Field[] fieldArray = ReflectionUtils.getDeclaredAndInheritedFields(parentObject.getClass(), false);
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> childObjClass;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (this.mapper.getJcrom().getAnnotationReader().isAnnotationPresent(field, JcrChildNode.class).booleanValue() && (childObjClass = ReflectionUtils.implementsInterface(field.getType(), List.class) ? ReflectionUtils.getParameterizedClass(field) : (ReflectionUtils.implementsInterface(field.getType(), Map.class) ? ReflectionUtils.getParameterizedClass(field, 1) : field.getType())).isAssignableFrom(type)) {
                JcrChildNode jcrChildNode = this.mapper.getJcrom().getAnnotationReader().getAnnotation(field, JcrChildNode.class);
                String nodeName = this.getNodeName(field);
                if (jcrChildNode.createContainerNode()) {
                    if (!parentNode.hasNode(nodeName)) {
                        throw new IllegalAccessException("The child container node not found with name '" + nodeName + "' from parent node '" + parentNode.getPath() + "'");
                    }
                    Node n3 = parentNode.getNode(nodeName);
                    containers.add(n3.getPath());
                } else {
                    children.add(nodeName);
                }
            }
            ++n2;
        }
        if (containers.isEmpty() && !children.contains(childNodeName)) {
            throw new IllegalAccessException("Child object not found with name '" + childNodeName + "' and type '" + type + "' from parent object '" + parentObject.getClass() + "'");
        }
        return containers;
    }
}

