/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jcr.Node;
import javax.jcr.Session;
import org.jcrom.AbstractLazyLoader;
import org.jcrom.Mapper;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.util.NodeFilter;
import org.jcrom.util.PathUtils;

class FileNodeListLoader
extends AbstractLazyLoader {
    private static final Logger logger = Logger.getLogger(FileNodeListLoader.class.getName());
    private final Class<?> objectClass;
    private final String fileContainerPath;
    private final Object parentObject;
    private final JcrFileNode jcrFileNode;
    private final int depth;
    private final NodeFilter nodeFilter;

    FileNodeListLoader(Class<?> objectClass, Object parentObject, String fileContainerPath, Session session, Mapper mapper, int depth, NodeFilter nodeFilter, JcrFileNode jcrFileNode) {
        super(session, mapper);
        this.objectClass = objectClass;
        this.parentObject = parentObject;
        this.jcrFileNode = jcrFileNode;
        this.fileContainerPath = fileContainerPath;
        this.depth = depth;
        this.nodeFilter = nodeFilter;
    }

    @Override
    protected Object doLoadObject(Session session, Mapper mapper) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Lazy loading file list for " + this.fileContainerPath);
        }
        Node fileContainer = PathUtils.getNode(this.fileContainerPath, session);
        return mapper.getFileNodeMapper().getFileList(this.objectClass, fileContainer, this.parentObject, this.jcrFileNode, this.depth, this.nodeFilter, mapper);
    }
}

