/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jcrom.JcrFile;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.annotations.JcrBaseVersionCreated;
import org.jcrom.annotations.JcrBaseVersionName;
import org.jcrom.annotations.JcrCheckedout;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrCreated;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrIdentifier;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrParentNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;
import org.jcrom.annotations.JcrSerializedProperty;
import org.jcrom.annotations.JcrUUID;
import org.jcrom.annotations.JcrVersionCreated;
import org.jcrom.annotations.JcrVersionName;
import org.jcrom.util.ReflectionUtils;

class Validator {
    private static final Logger logger = Logger.getLogger(Validator.class.getName());
    private final Jcrom jcrom;

    public Validator(Jcrom jcrom) {
        this.jcrom = jcrom;
    }

    Set<Class<?>> validate(Class<?> c, boolean dynamicInstantiation) {
        HashSet validClasses = new HashSet();
        this.validateInternal(c, validClasses, dynamicInstantiation);
        return validClasses;
    }

    private void validateInternal(Class<?> c, Set<Class<?>> validClasses, boolean dynamicInstantiation) {
        if (!validClasses.contains(c)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.finer("Processing class: " + c.getName());
            }
            validClasses.add(c);
            if (!c.isInterface() || !dynamicInstantiation) {
                this.validateFields(c, ReflectionUtils.getDeclaredAndInheritedFields(c, true), validClasses, dynamicInstantiation);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateFields(Class<?> c, Field[] fields, Set<Class<?>> validClasses, boolean dynamicInstantiation) {
        boolean foundNameField = false;
        boolean foundPathField = false;
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> valueParamClass;
            Class<?> keyParamClass;
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (logger.isLoggable(Level.FINE)) {
                logger.finer("In [" + c.getName() + "]: Processing field: " + field.getName());
            }
            if (this.jcrom.getAnnotationReader().isAnnotationPresent(field, JcrProperty.class).booleanValue()) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    if (!ReflectionUtils.isFieldParameterizedWithPropertyType(field)) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is a List annotated as @JcrProperty is not parameterized with a property type.");
                    }
                } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    keyParamClass = ReflectionUtils.getParameterizedClass(field, 0);
                    if (keyParamClass == null || keyParamClass != String.class) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrProperty is a java.util.Map that is not parameterised with a java.lang.String key type.");
                    }
                    valueParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                    if (valueParamClass == null || !ReflectionUtils.isValidMapValueType(valueParamClass)) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrProperty is a java.util.Map that is not parameterised with a valid value property type.");
                    }
                } else if (!ReflectionUtils.isPropertyType(field.getType())) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrProperty is not a valid JCR property (type is " + field.getType().getName() + ").");
                }
            } else if (field.isAnnotationPresent(JcrSerializedProperty.class)) {
                if (!ReflectionUtils.implementsInterface(field.getType(), Serializable.class)) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrSerializedProperty does not implement java.io.Serializable (type is " + field.getType().getName() + ").");
                }
            } else if (field.isAnnotationPresent(JcrName.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrName must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundNameField = true;
            } else if (field.isAnnotationPresent(JcrUUID.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrUUID must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrIdentifier.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrIdentifier must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrPath.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrPath must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
                foundPathField = true;
            } else if (field.isAnnotationPresent(JcrBaseVersionName.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrBaseVersionName must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrBaseVersionCreated.class)) {
                if (!ReflectionUtils.isDateType(field.getType())) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrBaseVersionCreated must be of type java.util.Date / java.util.Calendar / java.sql.Timestamp, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrVersionName.class)) {
                if (field.getType() != String.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrVersionName must be of type java.lang.String, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrVersionCreated.class)) {
                if (!ReflectionUtils.isDateType(field.getType())) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrVersionCreated must be of type java.util.Date / java.util.Calendar / java.sql.Timestamp, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrCheckedout.class)) {
                if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrCheckedout must be of type boolean, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrCreated.class)) {
                if (!ReflectionUtils.isDateType(field.getType())) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrCreated must be of type java.util.Date / java.util.Calendar / java.sql.Timestamp, but is of type: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrParentNode.class)) {
                this.validateInternal(field.getType(), validClasses, dynamicInstantiation);
            } else if (field.isAnnotationPresent(JcrChildNode.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    Class<?> paramClass = ReflectionUtils.getParameterizedClass(field);
                    if (paramClass == null) throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.List that is not parameterised with a valid class type.");
                    this.validateInternal(ReflectionUtils.getParameterizedClass(field), validClasses, dynamicInstantiation);
                } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    keyParamClass = ReflectionUtils.getParameterizedClass(field, 0);
                    if (keyParamClass == null || keyParamClass != String.class) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.Map that is not parameterised with a java.lang.String key type.");
                    }
                    valueParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                    Class<?> valueParamParamClass = ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0);
                    if (valueParamClass == null || valueParamClass != Object.class && (!ReflectionUtils.implementsInterface(valueParamClass, List.class) || valueParamParamClass == null || valueParamParamClass != Object.class)) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrChildNode is a java.util.Map that is not parameterised with a valid value type (Object or List<Object>).");
                    }
                } else {
                    this.validateInternal(field.getType(), validClasses, dynamicInstantiation);
                }
            } else if (field.isAnnotationPresent(JcrFileNode.class)) {
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    if (!ReflectionUtils.extendsClass(ReflectionUtils.getParameterizedClass(field), JcrFile.class)) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is a List annotated as @JcrFileNode is not parameterized with a JcrFile implementation.");
                    }
                } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    keyParamClass = ReflectionUtils.getParameterizedClass(field, 0);
                    if (keyParamClass == null || keyParamClass != String.class) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrFileNode is a java.util.Map that is not parameterised with a java.lang.String key type.");
                    }
                    valueParamClass = ReflectionUtils.getParameterizedClass(field, 1);
                    Class<?> valueParamParamClass = ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0);
                    if (!(valueParamClass != null && (ReflectionUtils.extendsClass(valueParamClass, JcrFile.class) || ReflectionUtils.implementsInterface(valueParamClass, List.class) && valueParamParamClass != null && ReflectionUtils.extendsClass(valueParamParamClass, JcrFile.class)))) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrFileNode is a java.util.Map that is not parameterised with a valid value type (JcrFile or List<JcrFile>).");
                    }
                } else if (!ReflectionUtils.extendsClass(field.getType(), JcrFile.class)) {
                    throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrFileNode is of type that does not extend JcrFile: " + field.getType().getName());
                }
            } else if (field.isAnnotationPresent(JcrReference.class)) {
                Class<?> fieldType;
                if (ReflectionUtils.implementsInterface(field.getType(), List.class)) {
                    fieldType = ReflectionUtils.getParameterizedClass(field);
                } else if (ReflectionUtils.implementsInterface(field.getType(), Map.class)) {
                    Class<?> keyParamClass2 = ReflectionUtils.getParameterizedClass(field, 0);
                    if (keyParamClass2 == null || keyParamClass2 != String.class) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrReference is a java.util.Map that is not parameterised with a java.lang.String key type.");
                    }
                    Class<?> valueParamClass2 = ReflectionUtils.getParameterizedClass(field, 1);
                    Class<?> valueParamParamClass = ReflectionUtils.getTypeArgumentOfParameterizedClass(field, 1, 0);
                    if (valueParamClass2 == null || valueParamClass2 != Object.class && (!ReflectionUtils.implementsInterface(valueParamClass2, List.class) || valueParamParamClass == null || valueParamParamClass != Object.class)) {
                        throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrReference is a java.util.Map that is not parameterised with a valid value type (Object or List<Object>).");
                    }
                    fieldType = null;
                } else {
                    fieldType = field.getType();
                }
                if (fieldType != null) {
                    JcrReference jcrReference = this.jcrom.getAnnotationReader().getAnnotation(field, JcrReference.class);
                    if (!(jcrReference.byPath() || fieldType.isInterface() && dynamicInstantiation)) {
                        boolean foundUUID = false;
                        boolean foundId = false;
                        Field[] fieldArray2 = ReflectionUtils.getDeclaredAndInheritedFields(fieldType, true);
                        int n3 = fieldArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Field refField = fieldArray2[n4];
                            if (refField.isAnnotationPresent(JcrUUID.class)) {
                                foundUUID = true;
                            }
                            if (refField.isAnnotationPresent(JcrIdentifier.class)) {
                                foundId = true;
                            }
                            ++n4;
                        }
                        if (!foundUUID && !foundId) {
                            throw new JcrMappingException("In [" + c.getName() + "]: Field [" + field.getName() + "] which is annotated as @JcrReference is of type that has no @JcrUUID or @JcrIdentifier: " + field.getType().getName());
                        }
                    }
                    this.validateInternal(fieldType, validClasses, dynamicInstantiation);
                }
            }
            ++n2;
        }
        if (!foundNameField) {
            throw new JcrMappingException("In [" + c.getName() + "]: No field is annotated with @JcrName.");
        }
        if (foundPathField) return;
        throw new JcrMappingException("In [" + c.getName() + "]: No field is annotated with @JcrPath.");
    }
}

