/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.dao;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.annotations.JcrNode;
import org.jcrom.dao.JcrDAO;
import org.jcrom.util.JcrUtils;
import org.jcrom.util.PathUtils;
import org.jcrom.util.ReflectionUtils;

public abstract class AbstractJcrDAO<T>
implements JcrDAO<T> {
    protected final Jcrom jcrom;
    protected final Session session;
    protected final Class<T> entityClass;
    protected final String[] mixinTypes;
    protected final boolean isVersionable;

    public AbstractJcrDAO(Jcrom jcrom) {
        this(null, null, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Session session, Jcrom jcrom) {
        this(null, session, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Jcrom jcrom) {
        this(entityClass, null, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom) {
        this(entityClass, session, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom, String[] mixinTypes) {
        if (entityClass == null) {
            Class<?> clazz = this.getClass();
            while (!(clazz.getGenericSuperclass() instanceof ParameterizedType)) {
                clazz = clazz.getSuperclass();
            }
            this.entityClass = (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
        } else {
            this.entityClass = entityClass;
        }
        this.session = session;
        this.jcrom = jcrom;
        this.mixinTypes = new String[mixinTypes.length];
        System.arraycopy(mixinTypes, 0, this.mixinTypes, 0, mixinTypes.length);
        this.isVersionable = this.checkIfVersionable();
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    protected Session getSession() {
        return this.session;
    }

    protected Jcrom getJcrom() {
        return this.jcrom;
    }

    protected String[] getMixinTypes() {
        return this.mixinTypes;
    }

    private boolean checkIfVersionable() {
        String[] stringArray = this.getMixinTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String mixinType = stringArray[n2];
            if (mixinType.equals("mix:versionable") || mixinType.equals("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                return true;
            }
            ++n2;
        }
        JcrNode jcrNode = ReflectionUtils.getJcrNodeAnnotation(this.getEntityClass());
        if (jcrNode != null && jcrNode.mixinTypes() != null) {
            String[] stringArray2 = jcrNode.mixinTypes();
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String mixinType = stringArray2[n];
                if (mixinType.equals("mix:versionable") || mixinType.equals("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected Node getNodeById(String id) throws RepositoryException {
        return this.getSession().getNodeByIdentifier(id);
    }

    protected Node getNode(String absolutePath) throws RepositoryException {
        return PathUtils.getNode(absolutePath, this.getSession());
    }

    protected NodeIterator getNodes(String absolutePath) throws RepositoryException {
        return PathUtils.getNodes(absolutePath, this.getSession());
    }

    @Override
    public T create(T entity) {
        return this.create(this.getParentPath(entity), entity);
    }

    private String getParentPath(T entity) {
        try {
            String entityPath = this.getJcrom().getPath(entity);
            String parentPath = entityPath != null ? entityPath : "/";
            Object parentObject = this.getJcrom().getParentObject(entity);
            if (parentObject != null) {
                parentPath = this.getJcrom().getPath(parentObject);
                if (!this.exists(parentPath)) {
                    throw new JcrMappingException("the parent with path '" + parentPath + "' is not created!");
                }
                Node parentNode = this.getNode(parentPath);
                String childContainerPath = this.getJcrom().getChildContainerPath(entity, parentObject, parentNode);
                if (childContainerPath != null) {
                    parentPath = childContainerPath;
                }
            }
            return parentPath;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not retrieve parent path", e);
        }
    }

    @Override
    public T create(String parentNodePath, T entity) {
        try {
            String entityName = this.getJcrom().getName(entity);
            if (entityName == null || entityName.equals("")) {
                throw new JcrMappingException("The name of the entity being created is empty!");
            }
            if (parentNodePath == null || parentNodePath.equals("")) {
                throw new JcrMappingException("The parent path of the entity being created is empty!");
            }
            Node parentNode = this.getNode(parentNodePath);
            if (this.isVersionable && (JcrUtils.hasMixinType(parentNode, "mix:versionable") || JcrUtils.hasMixinType(parentNode, "{http://www.jcp.org/jcr/mix/1.0}versionable"))) {
                JcrUtils.checkout(parentNode);
            }
            Node newNode = this.getJcrom().addNode(parentNode, entity, this.getMixinTypes());
            newNode.getSession().save();
            if (this.isVersionable) {
                JcrUtils.checkinRecursively(newNode);
                if ((JcrUtils.hasMixinType(parentNode, "mix:versionable") || JcrUtils.hasMixinType(parentNode, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && parentNode.isCheckedOut()) {
                    JcrUtils.checkin(parentNode);
                }
            }
            return entity;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not create node", e);
        }
    }

    @Override
    public T update(T entity) {
        return this.update(entity, "*", -1);
    }

    @Override
    public T update(T entity, String childNameFilter, int maxDepth) {
        Node node;
        try {
            node = this.getNode(this.getJcrom().getPath(entity));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
        return this.update(node, entity, childNameFilter, maxDepth);
    }

    @Override
    @Deprecated
    public T updateByUUID(T entity, String uuid) {
        return this.updateById(entity, uuid, "*", -1);
    }

    @Override
    public T updateById(T entity, String id) {
        return this.updateById(entity, id, "*", -1);
    }

    @Override
    @Deprecated
    public T updateByUUID(T entity, String uuid, String childNameFilter, int maxDepth) {
        return this.updateById(entity, uuid, childNameFilter, maxDepth);
    }

    @Override
    public T updateById(T entity, String id, String childNameFilter, int maxDepth) {
        Node node;
        try {
            node = this.getNodeById(id);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
        return this.update(node, entity, childNameFilter, maxDepth);
    }

    protected T update(Node node, T entity, String childNameFilter, int maxDepth) {
        try {
            if (this.isVersionable) {
                JcrUtils.checkoutRecursively(node);
            }
            Node updatedNode = this.getJcrom().updateNode(node, entity, childNameFilter, maxDepth);
            updatedNode.getSession().save();
            if (this.isVersionable) {
                JcrUtils.checkinRecursively(updatedNode);
            }
            return entity;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not update node", e);
        }
    }

    @Override
    public void move(T entity, String newParentPath) {
        try {
            String sourcePath = this.getJcrom().getPath(entity);
            String entityName = this.getJcrom().getName(entity);
            Node oldParent = null;
            Node newParent = null;
            if (this.isVersionable) {
                oldParent = this.getNode(sourcePath).getParent();
                newParent = this.getNode(newParentPath);
                if (JcrUtils.hasMixinType(oldParent, "mix:versionable") || JcrUtils.hasMixinType(oldParent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                    JcrUtils.checkout(oldParent);
                }
                if (JcrUtils.hasMixinType(newParent, "mix:versionable") || JcrUtils.hasMixinType(newParent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                    JcrUtils.checkout(newParent);
                }
            }
            Session session = this.getSession();
            if (newParentPath.equals("/")) {
                session.move(sourcePath, String.valueOf(newParentPath) + entityName);
            } else {
                session.move(sourcePath, String.valueOf(newParentPath) + "/" + entityName);
            }
            session.save();
            if (this.isVersionable) {
                if ((JcrUtils.hasMixinType(oldParent, "mix:versionable") || JcrUtils.hasMixinType(oldParent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && oldParent.isCheckedOut()) {
                    JcrUtils.checkin(oldParent);
                }
                if ((JcrUtils.hasMixinType(newParent, "mix:versionable") || JcrUtils.hasMixinType(newParent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && newParent.isCheckedOut()) {
                    JcrUtils.checkin(newParent);
                }
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not move node", e);
        }
    }

    @Override
    public void remove(String path) {
        try {
            Node parent = null;
            if (this.isVersionable && (JcrUtils.hasMixinType(parent = this.getNode(path).getParent(), "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable"))) {
                JcrUtils.checkout(parent);
            }
            Node node = this.getNode(path);
            node.remove();
            node.getSession().save();
            if (this.isVersionable && (JcrUtils.hasMixinType(parent, "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && parent.isCheckedOut()) {
                JcrUtils.checkin(parent);
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", e);
        }
    }

    @Override
    @Deprecated
    public void removeByUUID(String uuid) {
        this.removeById(uuid);
    }

    @Override
    public void removeById(String id) {
        try {
            Node node = this.getNodeById(id);
            Node parent = null;
            if (this.isVersionable && (JcrUtils.hasMixinType(parent = node.getParent(), "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable"))) {
                JcrUtils.checkout(parent);
            }
            node.remove();
            node.getSession().save();
            if (this.isVersionable && (JcrUtils.hasMixinType(parent, "mix:versionable") || JcrUtils.hasMixinType(parent, "{http://www.jcp.org/jcr/mix/1.0}versionable")) && parent.isCheckedOut()) {
                JcrUtils.checkin(parent);
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove node", e);
        }
    }

    @Override
    public boolean exists(String path) {
        try {
            return this.getSession().getRootNode().hasNode(PathUtils.relativePath(path));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not check if node exists", e);
        }
    }

    @Override
    public T get(String path) {
        return this.get(path, "*", -1);
    }

    @Override
    public T get(String path, String childNameFilter, int maxDepth) {
        if (this.exists(path)) {
            Node node;
            try {
                node = this.getNode(path);
            }
            catch (RepositoryException e) {
                throw new JcrMappingException("Could not get node", e);
            }
            return this.getJcrom().fromNode(this.getEntityClass(), node, childNameFilter, maxDepth);
        }
        return null;
    }

    @Override
    public List<T> getAll(String path) {
        return this.getAll(path, "*", -1);
    }

    @Override
    public List<T> getAll(String path, long startIndex, long resultSize) {
        return this.getAll(path, "*", -1, startIndex, resultSize);
    }

    @Override
    public List<T> getAll(String path, String childNameFilter, int maxDepth) {
        try {
            return this.toList(this.getNodes(path), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get nodes", e);
        }
    }

    @Override
    public List<T> getAll(String path, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            NodeIterator nodeIterator = this.getNodes(path);
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get nodes", e);
        }
    }

    @Override
    @Deprecated
    public T loadByUUID(String uuid) {
        return this.loadById(uuid, "*", -1);
    }

    @Override
    public T loadById(String id) {
        return this.loadById(id, "*", -1);
    }

    @Override
    @Deprecated
    public T loadByUUID(String uuid, String childNameFilter, int maxDepth) {
        return this.loadById(uuid, childNameFilter, maxDepth);
    }

    @Override
    public T loadById(String id, String childNameFilter, int maxDepth) {
        Node node;
        try {
            node = this.getNodeById(id);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not load node", e);
        }
        return this.getJcrom().fromNode(this.getEntityClass(), node, childNameFilter, maxDepth);
    }

    @Override
    public T getVersion(String path, String versionName) {
        return this.getVersion(path, versionName, "*", -1);
    }

    @Override
    public T getVersion(String path, String versionName, String childNameFilter, int maxDepth) {
        try {
            return this.getVersion(this.getNode(path), versionName, childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    @Override
    @Deprecated
    public T getVersionByUUID(String uuid, String versionName) {
        return this.getVersionById(uuid, versionName, "*", -1);
    }

    @Override
    public T getVersionById(String id, String versionName) {
        return this.getVersionById(id, versionName, "*", -1);
    }

    @Override
    @Deprecated
    public T getVersionByUUID(String uuid, String versionName, String childNameFilter, int maxDepth) {
        return this.getVersionById(uuid, versionName, childNameFilter, maxDepth);
    }

    @Override
    public T getVersionById(String id, String versionName, String childNameFilter, int maxDepth) {
        try {
            Node node = this.getNodeById(id);
            return this.getVersion(node, versionName, childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    protected T getVersion(Node node, String versionName, String childNameFilter, int maxDepth) {
        try {
            VersionHistory versionHistory = JcrUtils.getVersionManager(node.getSession()).getVersionHistory(node.getPath());
            Version version = versionHistory.getVersion(versionName);
            return this.getJcrom().fromNode(this.getEntityClass(), version.getNodes().nextNode(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version", e);
        }
    }

    @Override
    public void restoreVersion(String path, String versionName) {
        this.restoreVersion(path, versionName, true);
    }

    @Override
    @Deprecated
    public void restoreVersionByUUID(String uuid, String versionName) {
        this.restoreVersionById(uuid, versionName, true);
    }

    @Override
    public void restoreVersionById(String id, String versionName) {
        this.restoreVersionById(id, versionName, true);
    }

    @Override
    public void restoreVersion(String path, String versionName, boolean removeExisting) {
        try {
            this.restoreVersion(this.getNode(path), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    @Override
    @Deprecated
    public void restoreVersionByUUID(String uuid, String versionName, boolean removeExisting) {
        this.restoreVersionById(uuid, versionName, removeExisting);
    }

    @Override
    public void restoreVersionById(String id, String versionName, boolean removeExisting) {
        try {
            Node node = this.getNodeById(id);
            this.restoreVersion(node, versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    protected void restoreVersion(Node node, String versionName, boolean removeExisting) {
        try {
            JcrUtils.checkout(node);
            JcrUtils.getVersionManager(node.getSession()).restore(node.getPath(), versionName, removeExisting);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not restore version", e);
        }
    }

    @Override
    public void removeVersion(String path, String versionName) {
        try {
            this.removeVersion(this.getNode(path), versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    @Override
    @Deprecated
    public void removeVersionByUUID(String uuid, String versionName) {
        this.removeVersionById(uuid, versionName);
    }

    @Override
    public void removeVersionById(String id, String versionName) {
        try {
            Node node = this.getNodeById(id);
            this.removeVersion(node, versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    protected void removeVersion(Node node, String versionName) {
        try {
            VersionHistory versionHistory = JcrUtils.getVersionManager(node.getSession()).getVersionHistory(node.getPath());
            versionHistory.removeVersion(versionName);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not remove version", e);
        }
    }

    @Override
    public long getVersionSize(String path) {
        try {
            return this.getVersionSize(this.getNode(path));
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    @Override
    @Deprecated
    public long getVersionSizeByUUID(String uuid) {
        return this.getVersionSizeById(uuid);
    }

    @Override
    public long getVersionSizeById(String id) {
        try {
            Node node = this.getNodeById(id);
            return this.getVersionSize(node);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    protected long getVersionSize(Node node) {
        try {
            VersionHistory versionHistory = JcrUtils.getVersionManager(node.getSession()).getVersionHistory(node.getPath());
            return versionHistory.getAllVersions().getSize() - 1L;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version history size", e);
        }
    }

    @Override
    public List<T> getVersionList(String path) {
        try {
            return this.getVersionList(this.getNode(path), "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth) {
        try {
            return this.getVersionList(this.getNode(path), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            return this.getVersionList(this.getNode(path), childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    @Deprecated
    public List<T> getVersionListByUUID(String uuid) {
        return this.getVersionListById(uuid);
    }

    @Override
    public List<T> getVersionListById(String id) {
        try {
            Node node = this.getNodeById(id);
            return this.getVersionList(node, "*", -1);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    @Deprecated
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth) {
        return this.getVersionListById(uuid, childNameFilter, maxDepth);
    }

    @Override
    public List<T> getVersionListById(String uuid, String childNameFilter, int maxDepth) {
        try {
            Node node = this.getNodeById(uuid);
            return this.getVersionList(node, childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    @Deprecated
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        return this.getVersionListById(uuid, childNameFilter, maxDepth, startIndex, resultSize);
    }

    @Override
    public List<T> getVersionListById(String id, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            Node node = this.getNodeById(id);
            return this.getVersionList(node, childNameFilter, maxDepth, startIndex, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionHistory versionHistory = JcrUtils.getVersionManager(node.getSession()).getVersionHistory(node.getPath());
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L);
            while (versionIterator.hasNext()) {
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    T entityVersion = this.getJcrom().fromNode(this.getEntityClass(), nodeIterator.nextNode(), childNameFilter, maxDepth);
                    Version baseVersion = JcrUtils.getVersionManager(node.getSession()).getBaseVersion(node.getPath());
                    this.getJcrom().setBaseVersionInfo(entityVersion, baseVersion.getName(), baseVersion.getCreated());
                    versionList.add(entityVersion);
                }
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            ArrayList<T> versionList = new ArrayList<T>();
            VersionHistory versionHistory = JcrUtils.getVersionManager(node.getSession()).getVersionHistory(node.getPath());
            VersionIterator versionIterator = versionHistory.getAllVersions();
            versionIterator.skip(1L + startIndex);
            long counter = 0L;
            while (versionIterator.hasNext()) {
                if (counter == resultSize) break;
                Version version = versionIterator.nextVersion();
                NodeIterator nodeIterator = version.getNodes();
                while (nodeIterator.hasNext()) {
                    versionList.add(this.getJcrom().fromNode(this.getEntityClass(), nodeIterator.nextNode(), childNameFilter, maxDepth));
                }
                ++counter;
            }
            return versionList;
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get version list", e);
        }
    }

    @Override
    public long getSize(String rootPath) {
        try {
            NodeIterator nodeIterator = this.getNode(rootPath).getNodes();
            return nodeIterator.getSize();
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not get list size", e);
        }
    }

    @Override
    public List<T> findAll(String rootPath) {
        return this.findAll(rootPath, "*", -1);
    }

    @Override
    public List<T> findAll(String rootPath, long startIndex, long resultSize) {
        return this.findAll(rootPath, "*", -1, startIndex, resultSize);
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth) {
        try {
            return this.toList(this.getNode(rootPath).getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes", e);
        }
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            NodeIterator nodeIterator = this.getNode(rootPath).getNodes();
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes", e);
        }
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpath, "xpath");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(xpath, "xpath");
            QueryResult result = query.execute();
            return this.toList(result.getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> findBySql(String sql, String childNameFilter, int maxDepth, long startIndex, long resultSize) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sql, "JCR-SQL2");
            QueryResult result = query.execute();
            NodeIterator nodeIterator = result.getNodes();
            nodeIterator.skip(startIndex);
            return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> findBySql(String sql, String childNameFilter, int maxDepth) {
        try {
            QueryManager queryManager = this.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sql, "JCR-SQL2");
            QueryResult result = query.execute();
            return this.toList(result.getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> findByQOM(Source source, Constraint constraint, Ordering[] orderings, Column[] columns, String childNameFilter, int maxDepth) {
        try {
            QueryObjectModelFactory factory = this.getSession().getWorkspace().getQueryManager().getQOMFactory();
            QueryObjectModel query = factory.createQuery(source, constraint, orderings, columns);
            QueryResult result = query.execute();
            return this.toList(result.getNodes(), childNameFilter, maxDepth);
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not find nodes by XPath", e);
        }
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth) {
        ArrayList<T> objects = new ArrayList<T>();
        while (nodeIterator.hasNext()) {
            objects.add(this.getJcrom().fromNode(this.getEntityClass(), nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth, long resultSize) {
        ArrayList<T> objects = new ArrayList<T>();
        long counter = 0L;
        while (nodeIterator.hasNext()) {
            if (counter == resultSize) break;
            objects.add(this.getJcrom().fromNode(this.getEntityClass(), nodeIterator.nextNode(), childNameFilter, maxDepth));
            ++counter;
        }
        return objects;
    }
}

