/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.jcrom.JcrMappingException;

public final class JcrUtils {
    private JcrUtils() {
    }

    public static boolean hasMixinType(Node node, String mixinType) throws RepositoryException {
        NodeType[] nodeTypeArray = node.getMixinNodeTypes();
        int n = nodeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeType nodeType = nodeTypeArray[n2];
            if (nodeType.getName().equals(mixinType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static VersionManager getVersionManager(Session session) throws RepositoryException {
        VersionManager versionMgr = session.getWorkspace().getVersionManager();
        return versionMgr;
    }

    public static void checkout(Node node) throws RepositoryException {
        JcrUtils.getVersionManager(node.getSession()).checkout(node.getPath());
    }

    public static Version checkin(Node node) throws RepositoryException {
        return JcrUtils.getVersionManager(node.getSession()).checkin(node.getPath());
    }

    public static void checkinRecursively(Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                JcrUtils.checkinRecursively(it.nextNode());
            }
            if (node.isCheckedOut() && node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                JcrUtils.checkin(node);
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-in", e);
        }
    }

    public static void checkoutRecursively(Node node) {
        try {
            NodeIterator it = node.getNodes();
            while (it.hasNext()) {
                JcrUtils.checkoutRecursively(it.nextNode());
            }
            if (!node.isCheckedOut() && node.isNodeType("{http://www.jcp.org/jcr/mix/1.0}versionable")) {
                JcrUtils.checkout(node);
            }
        }
        catch (RepositoryException e) {
            throw new JcrMappingException("Could not perform check-out", e);
        }
    }
}

