/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import java.io.Serializable;
import org.jcrom.util.NameFilter;

public class NodeFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEPTH_INFINITE = -1;
    public static final String INCLUDE_ALL = "*";
    public static final String EXCLUDE_ALL = "none";
    protected final NameFilter nameFilter;
    protected final int maxDepth;
    protected final int filterDepth;

    public NodeFilter(String fieldNameFilter, int maxDepth, int filterDepth) {
        this.nameFilter = new NameFilter(fieldNameFilter);
        this.maxDepth = maxDepth;
        this.filterDepth = filterDepth;
    }

    public NodeFilter(String fieldNameFilter, int maxDepth) {
        this(fieldNameFilter, maxDepth, -1);
    }

    public NodeFilter(String fieldNameFilter) {
        this(fieldNameFilter, -1, -1);
    }

    public NodeFilter(int maxDepth) {
        this(INCLUDE_ALL, maxDepth, -1);
    }

    public boolean isIncluded(String name, int depth) {
        if (this.filterDepth > -1 && depth > this.filterDepth) {
            return true;
        }
        return (this.maxDepth == -1 || depth < this.maxDepth) && this.nameFilter.isIncluded(name);
    }

    public boolean isDepthIncluded(int depth) {
        if (this.filterDepth > -1 && depth > this.filterDepth) {
            return true;
        }
        return this.maxDepth == -1 || depth < this.maxDepth;
    }

    public boolean isNameIncluded(String name) {
        return this.nameFilter.isIncluded(name);
    }

    public int getFilterDepth() {
        return this.filterDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public NameFilter getNameFilter() {
        return this.nameFilter;
    }
}

