/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class PathUtils {
    public static String replaceNonAlphanumeric(String str, char subst) {
        StringBuffer ret = new StringBuffer(str.length());
        char[] testChars = str.toCharArray();
        char lastChar = 'A';
        int i = 0;
        while (i < testChars.length) {
            if (Character.isLetterOrDigit(testChars[i]) || testChars[i] == '.' || testChars[i] == ':') {
                ret.append(testChars[i]);
                lastChar = testChars[i];
            } else if (i > 0 && i + 1 != testChars.length && lastChar != subst) {
                ret.append(subst);
                lastChar = subst;
            }
            ++i;
        }
        return ret.toString();
    }

    public static String createValidName(String str) {
        return PathUtils.replaceNonAlphanumeric(str, '_');
    }

    public static Node getNode(String absolutePath, Session session) throws RepositoryException {
        return absolutePath.equals("/") ? session.getRootNode() : session.getRootNode().getNode(PathUtils.relativePath(absolutePath));
    }

    public static NodeIterator getNodes(String absolutePath, Session session) throws RepositoryException {
        return absolutePath.equals("/") ? session.getRootNode().getNodes() : session.getRootNode().getNodes(PathUtils.relativePath(absolutePath));
    }

    public static String relativePath(String absolutePath) {
        if (absolutePath.charAt(0) == '/') {
            return absolutePath.substring(1);
        }
        return absolutePath;
    }

    public static Node getNodeById(String id, Session session) throws RepositoryException {
        return session.getNodeByIdentifier(id);
    }
}

