/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.util;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jcrom.JcrMappingException;
import org.jcrom.SessionFactory;

public final class SessionFactoryUtils {
    private SessionFactoryUtils() {
    }

    public static Session getSession(SessionFactory sessionFactory) throws JcrMappingException {
        try {
            if (sessionFactory == null) {
                throw new IllegalArgumentException("No sessionFactory specified");
            }
            Session session = sessionFactory.getSession();
            return session;
        }
        catch (RepositoryException ex) {
            throw new JcrMappingException("Could not open Jcr Session", ex);
        }
    }

    public static void releaseSession(Session session) {
        if (session == null) {
            return;
        }
        session.logout();
    }
}

