/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.db;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.marketing.db.CampaignReminder;
import com.axelor.apps.marketing.db.CampaignType;
import com.axelor.apps.marketing.db.TargetList;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="MARKETING_CAMPAIGN", indexes={@Index(columnList="name"), @Index(columnList="partner_template"), @Index(columnList="lead_template"), @Index(columnList="email_log"), @Index(columnList="campaign_type"), @Index(columnList="event_user"), @Index(columnList="team"), @Index(columnList="email_account"), @Index(columnList="partner_reminder_template"), @Index(columnList="lead_reminder_template")})
public class Campaign
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="MARKETING_CAMPAIGN_SEQ")
    @SequenceGenerator(name="MARKETING_CAMPAIGN_SEQ", sequenceName="MARKETING_CAMPAIGN_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Stage", selection="campaign.stage.select")
    private Integer stageSelect = 0;
    @Widget(title="Target Model")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<TargetList> targetModelSet;
    @Widget(title="Contact/Partners template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template partnerTemplate;
    @Widget(title="Leads template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template leadTemplate;
    @Widget(title="Email sending log")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile emailLog;
    @Widget(title="Campaign Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CampaignType campaignType;
    @Widget(title="Emailing")
    private Boolean emailing = Boolean.FALSE;
    @Widget(title="Manage an event per target")
    private Boolean manageAnEventPerTarget = Boolean.FALSE;
    @Widget(title="Manage attendees")
    private Boolean manageAttendees = Boolean.FALSE;
    @Widget(title="Generate event to the team and salesman in charge of the partner/leads")
    private Boolean generateEventPerPartnerOrLead = Boolean.FALSE;
    @Widget(title="Leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> leads;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partners;
    @Widget(title="Assigned to")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User eventUser;
    @Widget(title="Team")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Team team;
    @Widget(title="Email Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAccount emailAccount;
    @Widget(title="Subject")
    private String subject;
    @Widget(title="Event type", selection="icalendar.event.type.select")
    private Integer eventTypeSelect = 0;
    @Widget(title="Start date time")
    private LocalDateTime eventStartDateTime;
    @Widget(title="Duration")
    private Long duration = 0L;
    @Widget(title="Partner/Contacts Target List")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> partnerSet;
    @Widget(title="Leads Target List")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> leadSet;
    private Integer sequence = 0;
    private String report;
    @Widget(title="Event start")
    private LocalDateTime eventStartDateT;
    @Widget(title="Event end")
    private LocalDateTime eventEndDateT;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> invitedPartnerSet;
    @Widget(title="Leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> invitedLeadSet;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> notParticipatingPartnerSet;
    @Widget(title="Leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> notParticipatingLeadSet;
    @Widget(title="Partners")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Partner> presentPartnerSet;
    @Widget(title="Leads")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Lead> presentLeadSet;
    @Widget(title="Reminders")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="campaign", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<CampaignReminder> campaignReminderList;
    @Widget(title="Contact/Partner reminder template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template partnerReminderTemplate;
    @Widget(title="Lead reminder template")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Template leadReminderTemplate;
    @Widget(title="Allow the editing of the targets")
    private Boolean isAllowEditingOfTargets = Boolean.TRUE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Campaign() {
    }

    public Campaign(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getStageSelect() {
        return this.stageSelect == null ? 0 : this.stageSelect;
    }

    public void setStageSelect(Integer stageSelect) {
        this.stageSelect = stageSelect;
    }

    public Set<TargetList> getTargetModelSet() {
        return this.targetModelSet;
    }

    public void setTargetModelSet(Set<TargetList> targetModelSet) {
        this.targetModelSet = targetModelSet;
    }

    public void addTargetModelSetItem(TargetList item) {
        if (this.getTargetModelSet() == null) {
            this.setTargetModelSet(new HashSet<TargetList>());
        }
        this.getTargetModelSet().add(item);
    }

    public void removeTargetModelSetItem(TargetList item) {
        if (this.getTargetModelSet() == null) {
            return;
        }
        this.getTargetModelSet().remove((Object)item);
    }

    public void clearTargetModelSet() {
        if (this.getTargetModelSet() != null) {
            this.getTargetModelSet().clear();
        }
    }

    public Template getPartnerTemplate() {
        return this.partnerTemplate;
    }

    public void setPartnerTemplate(Template partnerTemplate) {
        this.partnerTemplate = partnerTemplate;
    }

    public Template getLeadTemplate() {
        return this.leadTemplate;
    }

    public void setLeadTemplate(Template leadTemplate) {
        this.leadTemplate = leadTemplate;
    }

    public MetaFile getEmailLog() {
        return this.emailLog;
    }

    public void setEmailLog(MetaFile emailLog) {
        this.emailLog = emailLog;
    }

    public CampaignType getCampaignType() {
        return this.campaignType;
    }

    public void setCampaignType(CampaignType campaignType) {
        this.campaignType = campaignType;
    }

    public Boolean getEmailing() {
        return this.emailing == null ? Boolean.FALSE : this.emailing;
    }

    public void setEmailing(Boolean emailing) {
        this.emailing = emailing;
    }

    public Boolean getManageAnEventPerTarget() {
        return this.manageAnEventPerTarget == null ? Boolean.FALSE : this.manageAnEventPerTarget;
    }

    public void setManageAnEventPerTarget(Boolean manageAnEventPerTarget) {
        this.manageAnEventPerTarget = manageAnEventPerTarget;
    }

    public Boolean getManageAttendees() {
        return this.manageAttendees == null ? Boolean.FALSE : this.manageAttendees;
    }

    public void setManageAttendees(Boolean manageAttendees) {
        this.manageAttendees = manageAttendees;
    }

    public Boolean getGenerateEventPerPartnerOrLead() {
        return this.generateEventPerPartnerOrLead == null ? Boolean.FALSE : this.generateEventPerPartnerOrLead;
    }

    public void setGenerateEventPerPartnerOrLead(Boolean generateEventPerPartnerOrLead) {
        this.generateEventPerPartnerOrLead = generateEventPerPartnerOrLead;
    }

    public Set<Lead> getLeads() {
        return this.leads;
    }

    public void setLeads(Set<Lead> leads) {
        this.leads = leads;
    }

    public void addLead(Lead item) {
        if (this.getLeads() == null) {
            this.setLeads(new HashSet<Lead>());
        }
        this.getLeads().add(item);
    }

    public void removeLead(Lead item) {
        if (this.getLeads() == null) {
            return;
        }
        this.getLeads().remove(item);
    }

    public void clearLeads() {
        if (this.getLeads() != null) {
            this.getLeads().clear();
        }
    }

    public Set<Partner> getPartners() {
        return this.partners;
    }

    public void setPartners(Set<Partner> partners) {
        this.partners = partners;
    }

    public void addPartner(Partner item) {
        if (this.getPartners() == null) {
            this.setPartners(new HashSet<Partner>());
        }
        this.getPartners().add(item);
    }

    public void removePartner(Partner item) {
        if (this.getPartners() == null) {
            return;
        }
        this.getPartners().remove(item);
    }

    public void clearPartners() {
        if (this.getPartners() != null) {
            this.getPartners().clear();
        }
    }

    public User getEventUser() {
        return this.eventUser;
    }

    public void setEventUser(User eventUser) {
        this.eventUser = eventUser;
    }

    public Team getTeam() {
        return this.team;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    public EmailAccount getEmailAccount() {
        return this.emailAccount;
    }

    public void setEmailAccount(EmailAccount emailAccount) {
        this.emailAccount = emailAccount;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Integer getEventTypeSelect() {
        return this.eventTypeSelect == null ? 0 : this.eventTypeSelect;
    }

    public void setEventTypeSelect(Integer eventTypeSelect) {
        this.eventTypeSelect = eventTypeSelect;
    }

    public LocalDateTime getEventStartDateTime() {
        return this.eventStartDateTime;
    }

    public void setEventStartDateTime(LocalDateTime eventStartDateTime) {
        this.eventStartDateTime = eventStartDateTime;
    }

    public Long getDuration() {
        return this.duration == null ? 0L : this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public Set<Partner> getPartnerSet() {
        return this.partnerSet;
    }

    public void setPartnerSet(Set<Partner> partnerSet) {
        this.partnerSet = partnerSet;
    }

    public void addPartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            this.setPartnerSet(new HashSet<Partner>());
        }
        this.getPartnerSet().add(item);
    }

    public void removePartnerSetItem(Partner item) {
        if (this.getPartnerSet() == null) {
            return;
        }
        this.getPartnerSet().remove(item);
    }

    public void clearPartnerSet() {
        if (this.getPartnerSet() != null) {
            this.getPartnerSet().clear();
        }
    }

    public Set<Lead> getLeadSet() {
        return this.leadSet;
    }

    public void setLeadSet(Set<Lead> leadSet) {
        this.leadSet = leadSet;
    }

    public void addLeadSetItem(Lead item) {
        if (this.getLeadSet() == null) {
            this.setLeadSet(new HashSet<Lead>());
        }
        this.getLeadSet().add(item);
    }

    public void removeLeadSetItem(Lead item) {
        if (this.getLeadSet() == null) {
            return;
        }
        this.getLeadSet().remove(item);
    }

    public void clearLeadSet() {
        if (this.getLeadSet() != null) {
            this.getLeadSet().clear();
        }
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public String getReport() {
        return this.report;
    }

    public void setReport(String report) {
        this.report = report;
    }

    public LocalDateTime getEventStartDateT() {
        return this.eventStartDateT;
    }

    public void setEventStartDateT(LocalDateTime eventStartDateT) {
        this.eventStartDateT = eventStartDateT;
    }

    public LocalDateTime getEventEndDateT() {
        return this.eventEndDateT;
    }

    public void setEventEndDateT(LocalDateTime eventEndDateT) {
        this.eventEndDateT = eventEndDateT;
    }

    public Set<Partner> getInvitedPartnerSet() {
        return this.invitedPartnerSet;
    }

    public void setInvitedPartnerSet(Set<Partner> invitedPartnerSet) {
        this.invitedPartnerSet = invitedPartnerSet;
    }

    public void addInvitedPartnerSetItem(Partner item) {
        if (this.getInvitedPartnerSet() == null) {
            this.setInvitedPartnerSet(new HashSet<Partner>());
        }
        this.getInvitedPartnerSet().add(item);
    }

    public void removeInvitedPartnerSetItem(Partner item) {
        if (this.getInvitedPartnerSet() == null) {
            return;
        }
        this.getInvitedPartnerSet().remove(item);
    }

    public void clearInvitedPartnerSet() {
        if (this.getInvitedPartnerSet() != null) {
            this.getInvitedPartnerSet().clear();
        }
    }

    public Set<Lead> getInvitedLeadSet() {
        return this.invitedLeadSet;
    }

    public void setInvitedLeadSet(Set<Lead> invitedLeadSet) {
        this.invitedLeadSet = invitedLeadSet;
    }

    public void addInvitedLeadSetItem(Lead item) {
        if (this.getInvitedLeadSet() == null) {
            this.setInvitedLeadSet(new HashSet<Lead>());
        }
        this.getInvitedLeadSet().add(item);
    }

    public void removeInvitedLeadSetItem(Lead item) {
        if (this.getInvitedLeadSet() == null) {
            return;
        }
        this.getInvitedLeadSet().remove(item);
    }

    public void clearInvitedLeadSet() {
        if (this.getInvitedLeadSet() != null) {
            this.getInvitedLeadSet().clear();
        }
    }

    public Set<Partner> getNotParticipatingPartnerSet() {
        return this.notParticipatingPartnerSet;
    }

    public void setNotParticipatingPartnerSet(Set<Partner> notParticipatingPartnerSet) {
        this.notParticipatingPartnerSet = notParticipatingPartnerSet;
    }

    public void addNotParticipatingPartnerSetItem(Partner item) {
        if (this.getNotParticipatingPartnerSet() == null) {
            this.setNotParticipatingPartnerSet(new HashSet<Partner>());
        }
        this.getNotParticipatingPartnerSet().add(item);
    }

    public void removeNotParticipatingPartnerSetItem(Partner item) {
        if (this.getNotParticipatingPartnerSet() == null) {
            return;
        }
        this.getNotParticipatingPartnerSet().remove(item);
    }

    public void clearNotParticipatingPartnerSet() {
        if (this.getNotParticipatingPartnerSet() != null) {
            this.getNotParticipatingPartnerSet().clear();
        }
    }

    public Set<Lead> getNotParticipatingLeadSet() {
        return this.notParticipatingLeadSet;
    }

    public void setNotParticipatingLeadSet(Set<Lead> notParticipatingLeadSet) {
        this.notParticipatingLeadSet = notParticipatingLeadSet;
    }

    public void addNotParticipatingLeadSetItem(Lead item) {
        if (this.getNotParticipatingLeadSet() == null) {
            this.setNotParticipatingLeadSet(new HashSet<Lead>());
        }
        this.getNotParticipatingLeadSet().add(item);
    }

    public void removeNotParticipatingLeadSetItem(Lead item) {
        if (this.getNotParticipatingLeadSet() == null) {
            return;
        }
        this.getNotParticipatingLeadSet().remove(item);
    }

    public void clearNotParticipatingLeadSet() {
        if (this.getNotParticipatingLeadSet() != null) {
            this.getNotParticipatingLeadSet().clear();
        }
    }

    public Set<Partner> getPresentPartnerSet() {
        return this.presentPartnerSet;
    }

    public void setPresentPartnerSet(Set<Partner> presentPartnerSet) {
        this.presentPartnerSet = presentPartnerSet;
    }

    public void addPresentPartnerSetItem(Partner item) {
        if (this.getPresentPartnerSet() == null) {
            this.setPresentPartnerSet(new HashSet<Partner>());
        }
        this.getPresentPartnerSet().add(item);
    }

    public void removePresentPartnerSetItem(Partner item) {
        if (this.getPresentPartnerSet() == null) {
            return;
        }
        this.getPresentPartnerSet().remove(item);
    }

    public void clearPresentPartnerSet() {
        if (this.getPresentPartnerSet() != null) {
            this.getPresentPartnerSet().clear();
        }
    }

    public Set<Lead> getPresentLeadSet() {
        return this.presentLeadSet;
    }

    public void setPresentLeadSet(Set<Lead> presentLeadSet) {
        this.presentLeadSet = presentLeadSet;
    }

    public void addPresentLeadSetItem(Lead item) {
        if (this.getPresentLeadSet() == null) {
            this.setPresentLeadSet(new HashSet<Lead>());
        }
        this.getPresentLeadSet().add(item);
    }

    public void removePresentLeadSetItem(Lead item) {
        if (this.getPresentLeadSet() == null) {
            return;
        }
        this.getPresentLeadSet().remove(item);
    }

    public void clearPresentLeadSet() {
        if (this.getPresentLeadSet() != null) {
            this.getPresentLeadSet().clear();
        }
    }

    public List<CampaignReminder> getCampaignReminderList() {
        return this.campaignReminderList;
    }

    public void setCampaignReminderList(List<CampaignReminder> campaignReminderList) {
        this.campaignReminderList = campaignReminderList;
    }

    public void addCampaignReminderListItem(CampaignReminder item) {
        if (this.getCampaignReminderList() == null) {
            this.setCampaignReminderList(new ArrayList<CampaignReminder>());
        }
        this.getCampaignReminderList().add(item);
        item.setCampaign(this);
    }

    public void removeCampaignReminderListItem(CampaignReminder item) {
        if (this.getCampaignReminderList() == null) {
            return;
        }
        this.getCampaignReminderList().remove((Object)item);
    }

    public void clearCampaignReminderList() {
        if (this.getCampaignReminderList() != null) {
            this.getCampaignReminderList().clear();
        }
    }

    public Template getPartnerReminderTemplate() {
        return this.partnerReminderTemplate;
    }

    public void setPartnerReminderTemplate(Template partnerReminderTemplate) {
        this.partnerReminderTemplate = partnerReminderTemplate;
    }

    public Template getLeadReminderTemplate() {
        return this.leadReminderTemplate;
    }

    public void setLeadReminderTemplate(Template leadReminderTemplate) {
        this.leadReminderTemplate = leadReminderTemplate;
    }

    public Boolean getIsAllowEditingOfTargets() {
        return this.isAllowEditingOfTargets == null ? Boolean.FALSE : this.isAllowEditingOfTargets;
    }

    public void setIsAllowEditingOfTargets(Boolean isAllowEditingOfTargets) {
        this.isAllowEditingOfTargets = isAllowEditingOfTargets;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Campaign)) {
            return false;
        }
        Campaign other = (Campaign)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("stageSelect", (Object)this.getStageSelect()).add("emailing", (Object)this.getEmailing()).add("manageAnEventPerTarget", (Object)this.getManageAnEventPerTarget()).add("manageAttendees", (Object)this.getManageAttendees()).add("generateEventPerPartnerOrLead", (Object)this.getGenerateEventPerPartnerOrLead()).add("subject", (Object)this.getSubject()).add("eventTypeSelect", (Object)this.getEventTypeSelect()).add("eventStartDateTime", (Object)this.getEventStartDateTime()).add("duration", (Object)this.getDuration()).add("sequence", (Object)this.getSequence()).omitNullValues().toString();
    }
}

