/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.web;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.crm.db.repo.LeadRepository;
import com.axelor.apps.marketing.db.Campaign;
import com.axelor.apps.marketing.db.repo.CampaignRepository;
import com.axelor.apps.marketing.service.CampaignService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class CampaignController {
    public void sendEmail(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            campaign = (Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId()));
            if (campaign.getLeadSet().isEmpty() && campaign.getPartnerSet().isEmpty()) {
                response.setFlash(I18n.get((String)"Please select target"));
                return;
            }
            MetaFile logFile = ((CampaignService)Beans.get(CampaignService.class)).sendEmail(campaign);
            if (logFile == null) {
                response.setFlash(I18n.get((String)"Emails sent successfully"));
            } else {
                response.setFlash(I18n.get((String)"Error in sending emails. Please check the log file generated."));
            }
            response.setValue("emailLog", (Object)logFile);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void sendReminderEmail(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            campaign = (Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId()));
            if (campaign.getInvitedPartnerSet().isEmpty() && campaign.getInvitedPartnerSet().isEmpty()) {
                response.setFlash(I18n.get((String)"Please add atleast one invited Partner or Lead."));
                return;
            }
            MetaFile logFile = ((CampaignService)Beans.get(CampaignService.class)).sendReminderEmail(campaign);
            if (logFile == null) {
                response.setFlash(I18n.get((String)"Emails sent successfully"));
            } else {
                response.setFlash(I18n.get((String)"Error in sending emails. Please check the log file generated."));
            }
            response.setValue("emailLog", (Object)logFile);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateEvents(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            campaign = (Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId()));
            ((CampaignService)Beans.get(CampaignService.class)).generateEvents(campaign);
            response.setAttr("plannedEventsPanel", "refresh", (Object)true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generateTargets(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            campaign = (Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId()));
            ((CampaignService)Beans.get(CampaignService.class)).generateTargets(campaign);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void inviteSelectedTargets(ActionRequest request, ActionResponse response) {
        Campaign campaignContext = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            ((CampaignService)Beans.get(CampaignService.class)).inviteSelectedTargets((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaignContext.getId())), campaignContext);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void inviteAllTargets(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            ((CampaignService)Beans.get(CampaignService.class)).inviteAllTargets((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId())));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void addParticipatingTargets(ActionRequest request, ActionResponse response) {
        Campaign campaignContext = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            ((CampaignService)Beans.get(CampaignService.class)).addParticipatingTargets((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaignContext.getId())), campaignContext);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void addNotParticipatingTargets(ActionRequest request, ActionResponse response) {
        Campaign campaignContext = (Campaign)((Object)request.getContext().asType(Campaign.class));
        try {
            ((CampaignService)Beans.get(CampaignService.class)).addNotParticipatingTargets((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaignContext.getId())), campaignContext);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void markPartnerPresent(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().getParent().asType(Campaign.class));
        Partner partner = (Partner)request.getContext().asType(Partner.class);
        partner = (Partner)((PartnerRepository)Beans.get(PartnerRepository.class)).find(partner.getId());
        try {
            ((CampaignService)Beans.get(CampaignService.class)).markPartnerPresent((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId())), partner);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void markLeadPresent(ActionRequest request, ActionResponse response) {
        Campaign campaign = (Campaign)((Object)request.getContext().getParent().asType(Campaign.class));
        Lead lead = (Lead)request.getContext().asType(Lead.class);
        lead = (Lead)((LeadRepository)Beans.get(LeadRepository.class)).find(lead.getId());
        try {
            ((CampaignService)Beans.get(CampaignService.class)).markLeadPresent((Campaign)((Object)((CampaignRepository)((Object)Beans.get(CampaignRepository.class))).find(campaign.getId())), lead);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

