/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.marketing.web;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.crm.db.Lead;
import com.axelor.apps.marketing.db.TargetList;
import com.axelor.apps.marketing.service.TargetListService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class TargetListController {
    public void openFilteredLeads(ActionRequest request, ActionResponse response) {
        TargetList targetList = (TargetList)((Object)request.getContext().asType(TargetList.class));
        String leadFilters = null;
        try {
            leadFilters = ((TargetListService)Beans.get(TargetListService.class)).getLeadQuery(targetList);
            if (leadFilters != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Leads")).model(Lead.class.getName()).add("grid", "lead-grid").add("form", "lead-form").domain(leadFilters).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void openFilteredPartners(ActionRequest request, ActionResponse response) {
        TargetList targetList = (TargetList)((Object)request.getContext().asType(TargetList.class));
        String partnerFilters = null;
        try {
            partnerFilters = ((TargetListService)Beans.get(TargetListService.class)).getPartnerQuery(targetList);
            if (partnerFilters != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Partners")).model(Partner.class.getName()).add("grid", "partner-grid").add("form", "partner-form").domain(partnerFilters).map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

