/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public final class ClassUtils {
    private static final String PROXY_CLASS_SEPARATOR = "$$";
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final String PATH_SEPARATOR = "/";
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String CLASS_FILE_SUFFIX = ".class";

    private ClassUtils() {
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader setContextClassLoader(ClassLoader classLoader) {
        ClassLoader contextLoader = ClassUtils.getContextClassLoader();
        if (classLoader == null || classLoader.equals(contextLoader)) {
            return null;
        }
        Thread.currentThread().setContextClassLoader(classLoader);
        return contextLoader;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = ClassUtils.class.getClassLoader();
        }
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    public static String resourceToClassName(String resource) {
        Objects.requireNonNull(resource, "resource name cannot be null.");
        return resource.replace(PATH_SEPARATOR, PACKAGE_SEPARATOR).substring(0, resource.length() - CLASS_FILE_SUFFIX.length());
    }

    public static String classToResourceName(String klass) {
        Objects.requireNonNull(klass, "class name cannot be null.");
        return klass.replace(PACKAGE_SEPARATOR, PATH_SEPARATOR) + CLASS_FILE_SUFFIX;
    }

    public static String classToResourceName(Class<?> klass) {
        Objects.requireNonNull(klass, "class cannot be null.");
        return ClassUtils.classToResourceName(klass.getName());
    }

    public static boolean isProxy(Object object) {
        return object != null && ClassUtils.isProxyClass(object.getClass());
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return clazz != null && ClassUtils.isProxyClassName(clazz.getName());
    }

    public static boolean isProxyClassName(String className) {
        return className != null && className.contains(PROXY_CLASS_SEPARATOR);
    }

    public static <T> Class<? super T> getRealClass(Class<T> proxyClass) {
        if (!ClassUtils.isProxyClass(proxyClass)) {
            return proxyClass;
        }
        Class<T> zuper = proxyClass.getSuperclass();
        while (ClassUtils.isProxyClass(zuper)) {
            zuper = ClassUtils.getRealClass(zuper);
        }
        return zuper;
    }

    public static URL getURL(String location) throws FileNotFoundException {
        Objects.requireNonNull(location, "Resource location must not be null");
        if (location.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = location.substring(CLASSPATH_URL_PREFIX.length());
            URL url = ClassUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException("Resource [" + path + "] not found in class path.");
            }
        }
        try {
            return new URL(location);
        }
        catch (MalformedURLException e) {
            try {
                return new File(location).toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new FileNotFoundException("Resource [" + location + "] not found.");
            }
        }
    }

    public static URL getResource(String location) {
        Objects.requireNonNull(location, "Resource location must not be null");
        String path = location;
        if (path.startsWith(CLASSPATH_URL_PREFIX)) {
            path = path.substring(CLASSPATH_URL_PREFIX.length());
        }
        return ClassUtils.getDefaultClassLoader().getResource(path);
    }
}

