/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.EnumSet;

public final class FileUtils {
    public static File getFile(String first, String ... more) {
        Preconditions.checkNotNull((Object)first, (Object)"first element must not be null");
        File file = new File(first);
        if (more != null) {
            for (String name : more) {
                file = new File(file, name);
            }
        }
        return file;
    }

    public static File getFile(File directory, String next, String ... more) {
        Preconditions.checkNotNull((Object)directory, (Object)"directory must not be null");
        Preconditions.checkNotNull((Object)next, (Object)"next element must not be null");
        File file = new File(directory, next);
        if (more != null) {
            for (String name : more) {
                file = new File(file, name);
            }
        }
        return file;
    }

    public static void copyDirectory(File source, File target) throws IOException {
        FileUtils.copyDirectory(source.toPath(), target.toPath());
    }

    public static void copyDirectory(Path source, Path target) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("Invalid source directory: " + source);
        }
        if (Files.exists(target, new LinkOption[0]) && !Files.isDirectory(target, new LinkOption[0])) {
            throw new IOException("Invalid target directory: " + target);
        }
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        DirCopier copier = new DirCopier(source, target);
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(source, opts, Integer.MAX_VALUE, copier);
    }

    public static void deleteDirectory(File directory) throws IOException {
        FileUtils.deleteDirectory(directory.toPath());
    }

    public static void deleteDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new IOException("Invalid directory: " + directory);
        }
        DirCleaner cleaner = new DirCleaner();
        EnumSet<FileVisitOption> opts = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
        Files.walkFileTree(directory, opts, Integer.MAX_VALUE, cleaner);
    }

    static class DirCleaner
    extends SimpleFileVisitor<Path> {
        DirCleaner() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            Files.delete(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    static class DirCopier
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path target;

        DirCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path dest = this.target.resolve(this.source.relativize(file));
            Files.copy(file, dest, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path dest = this.target.resolve(this.source.relativize(dir));
            try {
                Files.copy(dir, dest, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc == null) {
                Path dest = this.target.resolve(this.source.relativize(dir));
                try {
                    FileTime time = Files.getLastModifiedTime(dir, new LinkOption[0]);
                    Files.setLastModifiedTime(dest, time);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

