/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionUtils {
    private static Version version;
    private static final Pattern VERSION_PATTERN;

    public static Version getVersion() {
        if (version == null) {
            version = VersionUtils.createVersion();
        }
        return version;
    }

    private static Version createVersion() {
        String version = VersionUtils.class.getPackage().getImplementationVersion();
        if (version == null) {
            return Version.UNKNOWN;
        }
        return new Version(version);
    }

    static {
        VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:\\-rc(\\d+))?(-SNAPSHOT)?$");
    }

    public static class Version {
        public static Version UNKNOWN = new Version("0.0.0");
        public final String version;
        public final String feature;
        public final int major;
        public final int minor;
        public final int patch;
        public final int rc;
        public final boolean snapshot;

        Version(String version) {
            Matcher matcher = VERSION_PATTERN.matcher(version.trim());
            if (!matcher.matches()) {
                throw new IllegalStateException("Invalid version string.");
            }
            this.version = version.trim();
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.patch = Integer.parseInt(matcher.group(3));
            this.rc = matcher.group(4) != null ? Integer.parseInt(matcher.group(4)) : 0;
            this.feature = String.format("%s.%s", this.major, this.minor);
            this.snapshot = matcher.group(5) != null;
        }

        public String toString() {
            return this.version;
        }
    }
}

