/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.crypto;

import com.axelor.common.crypto.BytesEncryptor;
import com.axelor.common.crypto.Encryptor;
import com.axelor.common.crypto.OperationMode;
import com.axelor.common.crypto.PaddingScheme;
import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;

public class StringEncryptor
implements Encryptor<String, String> {
    private final BaseEncoding encoder;
    private final BytesEncryptor encryptor;
    private final String prefix;

    public StringEncryptor(BytesEncryptor encryptor) {
        this.encryptor = encryptor;
        this.encoder = BaseEncoding.base64();
        this.prefix = this.encoder.omitPadding().encode(BytesEncryptor.PREFIX_BYTES);
    }

    public static StringEncryptor cbc(String password) {
        return new StringEncryptor(new BytesEncryptor(OperationMode.CBC, PaddingScheme.PKCS5, password));
    }

    public static StringEncryptor gcm(String password) {
        return new StringEncryptor(new BytesEncryptor(OperationMode.GCM, PaddingScheme.NONE, password));
    }

    @Override
    public boolean isEncrypted(String message) {
        if (message == null || message.length() < this.prefix.length()) {
            return false;
        }
        String prefix = message.substring(0, this.prefix.length());
        if (!this.encoder.canDecode((CharSequence)prefix)) {
            return false;
        }
        byte[] bytes = this.encoder.omitPadding().decode((CharSequence)prefix);
        prefix = new String(bytes, StandardCharsets.UTF_8);
        return "$AES$".equals(prefix);
    }

    @Override
    public String encrypt(String message) {
        if (message == null || this.isEncrypted(message)) {
            return message;
        }
        byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
        return this.encoder.encode(this.encryptor.encrypt(bytes));
    }

    @Override
    public String decrypt(String encryptedMessage) {
        if (encryptedMessage == null || !this.isEncrypted(encryptedMessage)) {
            return encryptedMessage;
        }
        byte[] decrypted = this.encryptor.decrypt(this.encoder.decode((CharSequence)encryptedMessage));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    public String toString() {
        return MoreObjects.toStringHelper(StringEncryptor.class).addValue((Object)this.encryptor.getTransformation()).toString();
    }
}

