/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.OptionHelper;
import com.axelor.common.FileUtils;
import com.axelor.common.ResourceUtils;
import com.axelor.common.StringUtils;
import com.axelor.common.logging.ColorConverter;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggerConfiguration {
    private static final String DEFAULT_CONFIG = "logback.xml";
    private static final String LOGGING_CONFIG = "logging.config";
    private static final String LOGGING_PATH = "logging.path";
    private static final String LOGGING_PATTERN_FILE = "logging.pattern.file";
    private static final String LOGGING_PATTERN_CONSOLE = "logging.pattern.console";
    private static final Pattern LOGGING_LEVEL_PATTERN = Pattern.compile("logging\\.level\\.(.*?)");
    private static final String ANSI_LOG_PATTERN = "%clr(%d{yyyy-MM-dd HH:mm:ss.SSS}){faint} %clr(%5p) %clr(${PID:- }){magenta} %clr(---){faint} %clr([%15.15t]){faint} %clr(%-40.40logger{39}){cyan} %clr(:){faint} %m%n";
    private static final String FILE_LOG_PATTERN = "%d{yyyy-MM-dd HH:mm:ss.SSS} %5p ${PID:- } --- [%t] %-40.40logger{39} : %m%n";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
    private Properties config;

    public LoggerConfiguration(Properties config) {
        this.config = config;
    }

    private boolean isInstalled() {
        return this.context.getObject(LoggerConfiguration.class.getName()) != null;
    }

    private void markInstalled() {
        this.context.putObject(LoggerConfiguration.class.getName(), (Object)true);
    }

    private void markUninstalled() {
        this.context.removeObject(LoggerConfiguration.class.getName());
    }

    public void install() {
        if (this.isInstalled()) {
            return;
        }
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        if (System.getProperty("PID") == null) {
            System.setProperty("PID", this.getPid());
        }
        this.configure();
        this.markInstalled();
    }

    public void uninstall() {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.uninstall();
        this.markUninstalled();
    }

    private String getPid() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            return jvmName.split("@")[0];
        }
        catch (Throwable ex) {
            return "???";
        }
    }

    private void configure() {
        if (this.config.getProperty(LOGGING_CONFIG) != null) {
            File file = FileUtils.getFile(this.config.getProperty(LOGGING_CONFIG), new String[0]);
            if (file.exists()) {
                this.reset(file);
                return;
            }
            throw new RuntimeException("Unable to access logging config file: " + file);
        }
        if (ResourceUtils.getResource(DEFAULT_CONFIG) != null) {
            return;
        }
        this.reset(null);
        this.logger("com.axelor", Level.INFO);
        this.logger("org.apache.catalina.startup.DigesterFactory", Level.ERROR);
        this.logger("org.apache.catalina.util.LifecycleBase", Level.ERROR);
        this.logger("org.apache.coyote.http11.Http11NioProtocol", Level.WARN);
        this.logger("org.apache.sshd.common.util.SecurityUtils", Level.WARN);
        this.logger("org.apache.tomcat.util.net.NioSelectorPool", Level.WARN);
        this.logger("org.eclipse.jetty.util.component.AbstractLifeCycle", Level.ERROR);
        this.logger("org.hibernate.validator.internal.util.Version", Level.WARN);
        this.logger("org.pac4j.core.engine", Level.INFO);
        this.logger("com.axelor.auth.pac4j", Level.INFO);
        Level rootLevel = Level.ERROR;
        for (String key : this.config.stringPropertyNames()) {
            Matcher matcher = LOGGING_LEVEL_PATTERN.matcher(key);
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            Level level = Level.toLevel((String)this.config.getProperty(key, "ERROR"));
            if ("ROOT".equalsIgnoreCase(name)) {
                rootLevel = level;
            }
            this.logger(name, level);
        }
        Logger rootLogger = this.context.getLogger("ROOT");
        String logPath = this.config.getProperty(LOGGING_PATH);
        rootLogger.setLevel(rootLevel);
        if (!"OFF".equalsIgnoreCase(this.config.getProperty(LOGGING_PATTERN_CONSOLE))) {
            rootLogger.addAppender(this.createConsoleAppender());
        }
        if (!"OFF".equalsIgnoreCase(this.config.getProperty(LOGGING_PATTERN_FILE)) && !StringUtils.isBlank(logPath)) {
            rootLogger.addAppender(this.createFileAppender(Paths.get(logPath, "axelor.log").toString()));
        }
    }

    private void reset(File configFile) {
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.context);
        this.context.reset();
        this.conversionRule("clr", ColorConverter.class);
        if (configFile == null) {
            return;
        }
        try {
            configurator.doConfigure(configFile);
        }
        catch (JoranException e) {
            throw new RuntimeException(e);
        }
    }

    private Appender<ILoggingEvent> createConsoleAppender() {
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = this.config.getProperty(LOGGING_PATTERN_CONSOLE, ANSI_LOG_PATTERN);
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)this.context));
        encoder.setCharset(UTF8);
        appender.setName("CONSOLE");
        appender.setEncoder((Encoder)encoder);
        this.start((LifeCycle)encoder);
        this.start((LifeCycle)appender);
        return appender;
    }

    private Appender<ILoggingEvent> createFileAppender(String logFile) {
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = this.config.getProperty(LOGGING_PATTERN_FILE, FILE_LOG_PATTERN);
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)this.context));
        appender.setName("FILE");
        appender.setFile(logFile);
        appender.setEncoder((Encoder)encoder);
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
        rollingPolicy.setFileNamePattern(logFile + ".%i");
        rollingPolicy.setParent((FileAppender)appender);
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        this.start((LifeCycle)encoder);
        this.start((LifeCycle)rollingPolicy);
        this.start((LifeCycle)triggeringPolicy);
        this.start((LifeCycle)appender);
        return appender;
    }

    public void conversionRule(String word, Class<? extends Converter<?>> converter) {
        HashMap<String, String> registry = (HashMap<String, String>)this.context.getObject("PATTERN_RULE_REGISTRY");
        if (registry == null) {
            registry = new HashMap<String, String>();
            this.context.putObject("PATTERN_RULE_REGISTRY", registry);
        }
        registry.put(word, converter.getName());
    }

    private Logger logger(String name, Level level) {
        Logger logger = this.context.getLogger(name);
        if (level != null) {
            logger.setLevel(level);
        }
        return logger;
    }

    private void start(LifeCycle lifeCycle) {
        if (lifeCycle instanceof ContextAware) {
            ((ContextAware)lifeCycle).setContext((Context)this.context);
        }
        lifeCycle.start();
    }
}

