/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common.reflections;

import com.axelor.internal.asm.AnnotationVisitor;
import com.axelor.internal.asm.ClassReader;
import com.axelor.internal.asm.ClassVisitor;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

final class ClassScanner {
    private static final int ASM_FLAGS = 7;
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";
    private static final String OBJECT_CLASS_NAME_ASM = "java/lang/Object";
    private ClassLoader loader;
    private Map<String, Collector> collectors = new ConcurrentHashMap<String, Collector>();
    private Set<String> packages = new LinkedHashSet<String>();
    private Set<Pattern> pathPatterns = new LinkedHashSet<Pattern>();

    public ClassScanner(ClassLoader loader, String ... packages) {
        this.loader = loader;
        if (packages != null) {
            for (String name : packages) {
                this.packages.add(name);
            }
        }
    }

    public ClassScanner byURL(String pattern) {
        Objects.requireNonNull(pattern, "pattern must not be null");
        this.pathPatterns.add(Pattern.compile(pattern));
        return this;
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        Set<String> types;
        HashSet<Class<T>> classes = new HashSet<Class<T>>();
        try {
            types = this.getSubTypesOf(type.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (String sub : types) {
            try {
                Class<?> found = this.loader.loadClass(sub);
                classes.add(found.asSubclass(type));
            }
            catch (Throwable throwable) {}
        }
        return Collections.unmodifiableSet(classes);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<?> annotation) {
        HashSet classes = new HashSet();
        if (this.collectors.isEmpty()) {
            try {
                this.scan();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (String klass : this.collectors.keySet()) {
            Set my = this.collectors.get(klass).annotations;
            if (my == null || !my.contains(annotation.getName())) continue;
            try {
                classes.add(this.loader.loadClass(klass));
            }
            catch (Throwable throwable) {}
        }
        return Collections.unmodifiableSet(classes);
    }

    private Set<String> getSubTypesOf(String type) throws IOException {
        HashSet<String> types = new HashSet<String>();
        if (this.collectors.isEmpty()) {
            this.scan();
        }
        for (String klass : this.collectors.keySet()) {
            Set my = this.collectors.get(klass).superNames;
            if (my == null || !my.contains(type)) continue;
            types.add(klass);
            types.addAll(this.getSubTypesOf(klass));
        }
        return types;
    }

    private void scan() throws IOException {
        ClassPath classPath = ClassPath.from((ClassLoader)this.loader);
        HashMap<String, ClassPath.ClassInfo> classes = new HashMap<String, ClassPath.ClassInfo>();
        for (ClassPath.ClassInfo info : classPath.getTopLevelClasses()) {
            if (classes.containsKey(info.getName())) continue;
            classes.put(info.getName(), info);
        }
        if (this.packages.isEmpty()) {
            for (ClassPath.ClassInfo info : classes.values()) {
                try {
                    this.scan(info, classes);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            for (String pkg : this.packages) {
                for (ClassPath.ClassInfo info : classPath.getTopLevelClassesRecursive(pkg)) {
                    try {
                        this.scan(info, classes);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
        }
    }

    private void scan(ClassPath.ClassInfo info, Map<String, ClassPath.ClassInfo> classes) throws ClassNotFoundException {
        boolean matched;
        if (info == null || OBJECT_CLASS_NAME.equals(info.getName()) || this.collectors.containsKey(info.getName())) {
            return;
        }
        URL resource = info.url();
        boolean bl = matched = this.pathPatterns.isEmpty() || this.pathPatterns.stream().map(p -> p.matcher(resource.getFile()).matches()).findFirst().orElse(false) != false;
        if (!matched) {
            return;
        }
        try (InputStream is = resource.openStream();){
            ClassReader reader = new ClassReader(is);
            Collector collector = new Collector();
            reader.accept((ClassVisitor)collector, 7);
            this.collectors.put(info.getName(), collector);
            if (collector.superNames != null) {
                for (String base : collector.superNames) {
                    this.scan(classes.get(base), classes);
                }
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(info.getName());
        }
    }

    private static class Collector
    extends ClassVisitor {
        private Set<String> superNames;
        private Set<String> annotations;

        public Collector() {
            super(262144);
        }

        private void acceptSuper(String name) {
            if (name == null) {
                return;
            }
            if (this.superNames == null) {
                this.superNames = new HashSet<String>();
            }
            this.superNames.add(name.replace("/", "."));
        }

        private void acceptAnnotation(String name) {
            if (name == null || ClassScanner.OBJECT_CLASS_NAME_ASM.equals(name)) {
                return;
            }
            if (this.annotations == null) {
                this.annotations = new HashSet<String>();
            }
            this.annotations.add(name.replace("/", ".").substring(1, name.length() - 1));
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.acceptSuper(superName);
            if (interfaces != null) {
                for (String iface : interfaces) {
                    this.acceptSuper(iface);
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.acceptAnnotation(desc);
            return null;
        }
    }
}

