/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_ACCESS_CONFIG", uniqueConstraints={@UniqueConstraint(columnNames={"app", "name"})}, indexes={@Index(columnList="name"), @Index(columnList="app")})
public class AccessConfig
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_ACCESS_CONFIG_SEQ")
    @SequenceGenerator(name="BASE_ACCESS_CONFIG_SEQ", sequenceName="BASE_ACCESS_CONFIG_SEQ", allocationSize=1)
    private Long id;
    @Widget(readonly=true)
    private String name;
    @Widget(title="App")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private App app;
    @Widget(title="Roles")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roleSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AccessConfig() {
    }

    public AccessConfig(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public App getApp() {
        return this.app;
    }

    public void setApp(App app) {
        this.app = app;
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public void addRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            this.setRoleSet(new HashSet<Role>());
        }
        this.getRoleSet().add(item);
    }

    public void removeRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            return;
        }
        this.getRoleSet().remove(item);
    }

    public void clearRoleSet() {
        if (this.getRoleSet() != null) {
            this.getRoleSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AccessConfig)) {
            return false;
        }
        AccessConfig other = (AccessConfig)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

