/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.ObjectDataConfig;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="BASE_DATA_CONFIG_LINE", uniqueConstraints={@UniqueConstraint(columnNames={"object_data_config", "tabName"})}, indexes={@Index(columnList="meta_model"), @Index(columnList="meta_field_path"), @Index(columnList="object_data_config")})
public class DataConfigLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BASE_DATA_CONFIG_LINE_SEQ")
    @SequenceGenerator(name="BASE_DATA_CONFIG_LINE_SEQ", sequenceName="BASE_DATA_CONFIG_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Object")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaModel metaModel;
    @Widget(title="Query/path", selection="data.config.line.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Query")
    private String path;
    @Widget(title="Path Field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaFieldPath;
    @Widget(title="Fields to export")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaField> toExportMetaFieldSet;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ObjectDataConfig objectDataConfig;
    @Widget(title="Action to perform", selection="data.config.line.reset.path.select")
    private Integer resetPathSelect = 0;
    @Widget(title="Record", selection="object.data.config.model.select")
    private String record;
    private Long recordSelectId = 0L;
    @Widget(title="Fields to delete")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaField> toDeleteMetaFieldSet;
    @Widget(title="Tab name")
    @NotNull
    private String tabName;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public MetaModel getMetaModel() {
        return this.metaModel;
    }

    public void setMetaModel(MetaModel metaModel) {
        this.metaModel = metaModel;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public MetaField getMetaFieldPath() {
        return this.metaFieldPath;
    }

    public void setMetaFieldPath(MetaField metaFieldPath) {
        this.metaFieldPath = metaFieldPath;
    }

    public Set<MetaField> getToExportMetaFieldSet() {
        return this.toExportMetaFieldSet;
    }

    public void setToExportMetaFieldSet(Set<MetaField> toExportMetaFieldSet) {
        this.toExportMetaFieldSet = toExportMetaFieldSet;
    }

    public void addToExportMetaFieldSetItem(MetaField item) {
        if (this.getToExportMetaFieldSet() == null) {
            this.setToExportMetaFieldSet(new HashSet<MetaField>());
        }
        this.getToExportMetaFieldSet().add(item);
    }

    public void removeToExportMetaFieldSetItem(MetaField item) {
        if (this.getToExportMetaFieldSet() == null) {
            return;
        }
        this.getToExportMetaFieldSet().remove(item);
    }

    public void clearToExportMetaFieldSet() {
        if (this.getToExportMetaFieldSet() != null) {
            this.getToExportMetaFieldSet().clear();
        }
    }

    public ObjectDataConfig getObjectDataConfig() {
        return this.objectDataConfig;
    }

    public void setObjectDataConfig(ObjectDataConfig objectDataConfig) {
        this.objectDataConfig = objectDataConfig;
    }

    public Integer getResetPathSelect() {
        return this.resetPathSelect == null ? 0 : this.resetPathSelect;
    }

    public void setResetPathSelect(Integer resetPathSelect) {
        this.resetPathSelect = resetPathSelect;
    }

    public String getRecord() {
        return this.record;
    }

    public void setRecord(String record) {
        this.record = record;
    }

    public Long getRecordSelectId() {
        return this.recordSelectId == null ? 0L : this.recordSelectId;
    }

    public void setRecordSelectId(Long recordSelectId) {
        this.recordSelectId = recordSelectId;
    }

    public Set<MetaField> getToDeleteMetaFieldSet() {
        return this.toDeleteMetaFieldSet;
    }

    public void setToDeleteMetaFieldSet(Set<MetaField> toDeleteMetaFieldSet) {
        this.toDeleteMetaFieldSet = toDeleteMetaFieldSet;
    }

    public void addToDeleteMetaFieldSetItem(MetaField item) {
        if (this.getToDeleteMetaFieldSet() == null) {
            this.setToDeleteMetaFieldSet(new HashSet<MetaField>());
        }
        this.getToDeleteMetaFieldSet().add(item);
    }

    public void removeToDeleteMetaFieldSetItem(MetaField item) {
        if (this.getToDeleteMetaFieldSet() == null) {
            return;
        }
        this.getToDeleteMetaFieldSet().remove(item);
    }

    public void clearToDeleteMetaFieldSet() {
        if (this.getToDeleteMetaFieldSet() != null) {
            this.getToDeleteMetaFieldSet().clear();
        }
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataConfigLine)) {
            return false;
        }
        DataConfigLine other = (DataConfigLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("path", (Object)this.getPath()).add("resetPathSelect", (Object)this.getResetPathSelect()).add("record", (Object)this.getRecord()).add("recordSelectId", (Object)this.getRecordSelectId()).add("tabName", (Object)this.getTabName()).omitNullValues().toString();
    }
}

