/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.DataConfigLine;
import com.axelor.db.JpaRepository;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.db.mapper.Mapper;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaModelRepository;
import java.util.Locale;
import java.util.ResourceBundle;

public class ObjectDataCommonService {
    public static ResourceBundle getResourceBundle(String language) {
        ResourceBundle bundle = language == null ? I18n.getBundle() : (language.equals("fr") ? I18n.getBundle((Locale)Locale.FRANCE) : I18n.getBundle((Locale)Locale.ENGLISH));
        return bundle;
    }

    public static String getNameColumn(MetaField field) throws ClassNotFoundException {
        MetaModel metaModel = ((MetaModelRepository)Beans.get(MetaModelRepository.class)).findByName(field.getTypeName());
        return Mapper.of(ObjectDataCommonService.findModelClass(metaModel)).getNameField().getName();
    }

    public static Class<? extends Model> findModelClass(MetaModel metaModel) throws ClassNotFoundException {
        Class<?> modelClass = Class.forName(metaModel.getFullName());
        return modelClass;
    }

    public static Query<? extends Model> createQuery(Long recordId, DataConfigLine line, Class<? extends Model> modelClass) {
        Query query = JpaRepository.of(modelClass).all();
        String filter = line.getTypeSelect() == 0 ? ObjectDataCommonService.createFilter(line.getMetaFieldPath().getName()) : line.getPath();
        query.filter(filter, new Object[]{recordId});
        return query;
    }

    public static String createFilter(String path) {
        if (path == null || path.equals("id")) {
            path = "id";
        } else if (!path.endsWith(".id")) {
            path = path + ".id";
        }
        return "self." + path + " = ?1";
    }
}

