/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.apps.base.db.AccessConfig;
import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.repo.AccessConfigRepository;
import com.axelor.apps.base.service.app.AccessConfigImportService;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AccessConfigImportServiceImpl
implements AccessConfigImportService {
    @Inject
    private AppService appService;
    @Inject
    private AccessConfigRepository accessConfigRepo;
    @Inject
    private PermissionRepository permissionRepo;
    @Inject
    private RoleRepository roleRepo;
    @Inject
    private MetaMenuRepository metaMenuRepo;

    @Override
    public void importAccessConfig(MetaFile metaFile) throws AxelorException {
        if (metaFile == null) {
            return;
        }
        try {
            OPCPackage pkg = OPCPackage.open((String)MetaFiles.getPath((MetaFile)metaFile).toString());
            XSSFWorkbook workBook = new XSSFWorkbook(pkg);
            this.processWorkbook(workBook);
        }
        catch (IOException | InvalidFormatException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(0, e.getMessage());
        }
    }

    private void processWorkbook(XSSFWorkbook workBook) {
        for (XSSFSheet sheet : workBook) {
            String name = sheet.getSheetName();
            if (name.endsWith("-menu")) {
                this.importMenuAccess(sheet);
                continue;
            }
            this.importObjectAccess(sheet);
        }
    }

    private void importObjectAccess(XSSFSheet sheet) {
        App app = this.appService.getApp(sheet.getSheetName());
        if (app == null) {
            return;
        }
        Iterator rowIter = sheet.iterator();
        Map<Integer, AccessConfig> accessMap = null;
        while (rowIter.hasNext()) {
            if (accessMap == null) {
                accessMap = this.getAccessConfig((Row)rowIter.next(), app);
                continue;
            }
            this.createObjectRoles(accessMap, (Row)rowIter.next());
        }
    }

    @Transactional
    public Map<Integer, AccessConfig> getAccessConfig(Row row, App app) {
        HashMap<Integer, AccessConfig> configMap = new HashMap<Integer, AccessConfig>();
        Iterator cellIter = row.iterator();
        cellIter.next();
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            String name = cell.getStringCellValue();
            if (name == null) continue;
            AccessConfig config = (AccessConfig)((Object)this.accessConfigRepo.all().filter("self.name = ?1 and self.app = ?2", new Object[]{name, app}).fetchOne());
            if (config == null) {
                config = new AccessConfig(name);
                config.setApp(app);
                config = (AccessConfig)((Object)this.accessConfigRepo.save((Model)((Object)config)));
            }
            configMap.put(cell.getColumnIndex(), config);
        }
        return configMap;
    }

    private void createObjectRoles(Map<Integer, AccessConfig> accessMap, Row row) {
        Iterator cellIter = row.iterator();
        String obj = ((Cell)cellIter.next()).getStringCellValue();
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            String value = cell.getStringCellValue();
            if (cell == null || Strings.isNullOrEmpty((String)value) || this.invalidValue(value)) continue;
            AccessConfig config = accessMap.get(cell.getColumnIndex());
            Permission permission = this.getPermission(obj, value.trim(), config);
            this.addRole(config, permission);
        }
    }

    private boolean invalidValue(String value) {
        return !"rwcde".startsWith(value);
    }

    @Transactional
    public Permission getPermission(String model, String value, AccessConfig config) {
        String[] objs = model.split("\\.");
        String obj = objs[objs.length - 1];
        String pkg = objs[objs.length - 3];
        String name = "perm." + pkg + "." + obj + "." + value;
        Permission permission = (Permission)this.permissionRepo.all().filter("self.name = ?1 and self.object = ?2", new Object[]{name, model}).fetchOne();
        if (permission == null) {
            permission = new Permission(name);
            permission.setObject(model);
        }
        boolean defaultRight = value.equals("all");
        permission.setCanCreate(Boolean.valueOf(defaultRight));
        permission.setCanRead(Boolean.valueOf(defaultRight));
        permission.setCanWrite(Boolean.valueOf(defaultRight));
        permission.setCanRemove(Boolean.valueOf(defaultRight));
        permission.setCanExport(Boolean.valueOf(defaultRight));
        if (!defaultRight) {
            block7: for (char c : value.toCharArray()) {
                switch (c) {
                    case 'r': {
                        permission.setCanRead(Boolean.valueOf(true));
                        continue block7;
                    }
                    case 'c': {
                        permission.setCanCreate(Boolean.valueOf(true));
                        continue block7;
                    }
                    case 'w': {
                        permission.setCanWrite(Boolean.valueOf(true));
                        continue block7;
                    }
                    case 'd': {
                        permission.setCanRemove(Boolean.valueOf(true));
                        continue block7;
                    }
                    case 'e': {
                        permission.setCanExport(Boolean.valueOf(true));
                    }
                }
            }
        }
        return (Permission)this.permissionRepo.save((Model)permission);
    }

    @Transactional
    public void addRole(AccessConfig config, Permission permission) {
        String name = config.getApp().getCode() + "." + config.getName();
        Role role = this.roleRepo.findByName(name);
        if (role == null) {
            role = new Role(name);
        }
        role.addPermission(permission);
        role = (Role)this.roleRepo.save((Model)role);
        config.addRoleSetItem(role);
        this.accessConfigRepo.save((Model)((Object)config));
    }

    private void importMenuAccess(XSSFSheet sheet) {
        App app = this.appService.getApp(sheet.getSheetName().split("-")[0]);
        if (app == null) {
            return;
        }
        Iterator rowIter = sheet.iterator();
        Map<Integer, AccessConfig> accessMap = null;
        while (rowIter.hasNext()) {
            if (accessMap == null) {
                accessMap = this.getAccessConfig((Row)rowIter.next(), app);
                continue;
            }
            this.createMenuRoles(accessMap, (Row)rowIter.next());
        }
    }

    private void createMenuRoles(Map<Integer, AccessConfig> accessMap, Row row) {
        Iterator cellIter = row.iterator();
        String menu = ((Cell)cellIter.next()).getStringCellValue().trim();
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            String value = cell.getStringCellValue();
            if (cell == null || Strings.isNullOrEmpty((String)value)) continue;
            AccessConfig config = accessMap.get(cell.getColumnIndex());
            this.addRole(config, menu);
        }
    }

    @Transactional
    public void addRole(AccessConfig config, String menu) {
        MetaMenu metaMenu;
        String name = config.getApp().getCode() + "." + config.getName();
        Role role = this.roleRepo.findByName(name);
        if (role == null) {
            role = new Role(name);
        }
        if ((metaMenu = this.metaMenuRepo.findByName(menu)) != null) {
            metaMenu.addRole(role);
            this.metaMenuRepo.save((Model)metaMenu);
        }
        config.addRoleSetItem(role);
        this.accessConfigRepo.save((Model)((Object)config));
    }
}

