/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.common.StringUtils;
import com.axelor.data.Listener;
import com.axelor.data.csv.CSVImporter;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBackupRestoreService {
    public File restore(MetaFile zipedBackupFile) {
        Logger LOG = LoggerFactory.getLogger(this.getClass());
        File tempDir = com.google.common.io.Files.createTempDir();
        String dirPath = tempDir.getAbsolutePath();
        final StringBuilder sb = new StringBuilder();
        try {
            this.unZip(zipedBackupFile, dirPath);
            String configFName = tempDir.getAbsolutePath() + File.separator + "config.xml";
            CSVImporter csvImporter = new CSVImporter(configFName, tempDir.getAbsolutePath());
            csvImporter.addListener(new Listener(){
                String modelName;
                StringBuilder sb1 = new StringBuilder();

                public void handle(Model bean, Exception e) {
                    if (e.getMessage() != null && !e.getMessage().equals("null")) {
                        if (bean != null) {
                            this.sb1.append(bean.getClass().getSimpleName() + " : \n" + e.getMessage() + "\n\n");
                        } else {
                            this.sb1.append(e.getMessage() + "\n\n");
                        }
                    }
                }

                public void imported(Model model) {
                    this.modelName = model.getClass().getSimpleName();
                }

                public void imported(Integer total, Integer count) {
                    String str = "";
                    String strError = "";
                    if (!StringUtils.isBlank((CharSequence)this.sb1)) {
                        strError = "Errors : \n" + this.sb1.toString();
                    }
                    str = "Total Records :  {" + total + "} - Success Records :  {" + count + "}  \n";
                    if (total != 0 && count != 0) {
                        sb.append(this.modelName + " : \n");
                    }
                    sb.append(strError).append(str + "-----------------------------------------\n");
                    this.sb1.setLength(0);
                }
            });
            csvImporter.run();
            LOG.info("Data Restore Completed");
            FileUtils.cleanDirectory((File)new File(tempDir.getAbsolutePath()));
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmSS");
            String logFileName = "DataBackupLog_" + LocalDateTime.now().format(formatter) + ".log";
            File file = new File(tempDir.getAbsolutePath(), logFileName);
            PrintWriter pw = new PrintWriter(file);
            pw.write(sb.toString());
            pw.close();
            return file;
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            return null;
        }
    }

    private boolean unZip(MetaFile zipMetaFile, String destinationDirectoryPath) throws IOException {
        File zipFile = MetaFiles.getPath((MetaFile)zipMetaFile).toFile();
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(zipFile)));){
            ZipEntry ze;
            byte[] buffer = new byte[1024];
            while ((ze = zis.getNextEntry()) != null) {
                try (FileOutputStream fout = new FileOutputStream(new File(destinationDirectoryPath, ze.getName()));){
                    int count;
                    while ((count = zis.read(buffer)) != -1) {
                        fout.write(buffer, 0, count);
                    }
                }
                zis.closeEntry();
            }
            boolean bl = true;
            return bl;
        }
    }

    public boolean SeuencesExist() {
        long total = (Long)JPA.em().createQuery("SELECT count(*) FROM Sequence").getSingleResult();
        long total1 = (Long)JPA.em().createQuery("SELECT count(*) FROM MrpLineType").getSingleResult();
        return total > 0L || total1 > 0L;
    }

    public Object importObjectWithByteArray(Object bean, Map<String, Object> values) throws IOException {
        assert (bean instanceof Model);
        Path path = (Path)values.get("__path__");
        Mapper mapper = Mapper.of(bean.getClass());
        for (String fieldName : values.keySet()) {
            if (!fieldName.startsWith("byte_")) continue;
            String fileName = (String)values.get(fieldName);
            if (Strings.isNullOrEmpty((String)fileName)) {
                return bean;
            }
            try {
                File image = path.resolve(fileName).toFile();
                byte[] bytes = new byte[(int)image.length()];
                bytes = Files.readAllBytes(image.toPath());
                mapper.set(bean, fieldName.substring(5), (Object)bytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bean;
    }
}

