/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.repo.AppRepository;
import com.axelor.apps.base.service.app.AccessConfigImportService;
import com.axelor.apps.base.service.app.AccessTemplateService;
import com.axelor.apps.base.service.app.AppService;
import com.axelor.common.Inflector;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.db.repo.MetaViewRepository;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

@Singleton
public class AppController {
    public void importDataDemo(ActionRequest request, ActionResponse response) throws AxelorException {
        App app = (App)((Object)request.getContext().asType(App.class));
        app = (App)((Object)((AppRepository)((Object)Beans.get(AppRepository.class))).find(app.getId()));
        ((AppService)Beans.get(AppService.class)).importDataDemo(app);
        response.setFlash(I18n.get((String)"Demo data loaded successfully"));
        response.setReload(true);
    }

    public void installApp(ActionRequest request, ActionResponse response) throws AxelorException {
        App app = (App)((Object)request.getContext().asType(App.class));
        app = (App)((Object)((AppRepository)((Object)Beans.get(AppRepository.class))).find(app.getId()));
        ((AppService)Beans.get(AppService.class)).installApp(app, null);
        response.setSignal("refresh-app", (Object)true);
    }

    public void configure(ActionRequest request, ActionResponse response) {
        App app = (App)((Object)request.getContext().asType(App.class));
        String code = app.getCode();
        String appName = Inflector.getInstance().camelize(code);
        String viewName = "app-" + code + "-config-form";
        if (((MetaViewRepository)Beans.get(MetaViewRepository.class)).findByName(viewName) == null) {
            response.setFlash(I18n.get((String)"No configuration required"));
        } else {
            response.setView(ActionView.define((String)(I18n.get((String)"Configure") + ": " + app.getName())).add("form", viewName).model("com.axelor.apps.base.db.App" + appName).context("_showRecord", (Object)app.getId()).param("forceEdit", "true").map());
        }
    }

    public void uninstallApp(ActionRequest request, ActionResponse response) throws AxelorException {
        App app = (App)((Object)request.getContext().asType(App.class));
        app = (App)((Object)((AppRepository)((Object)Beans.get(AppRepository.class))).find(app.getId()));
        ((AppService)Beans.get(AppService.class)).unInstallApp(app);
        response.setSignal("refresh-app", (Object)true);
    }

    public void bulkInstall(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        HashSet apps = new HashSet();
        Collection appsSet = (Collection)context.get((Object)"appsSet");
        if (appsSet != null) {
            apps.addAll(appsSet);
        }
        Boolean importDemo = (Boolean)context.get((Object)"importDemoData");
        String language = (String)context.get((Object)"languageSelect");
        AppRepository appRepository = (AppRepository)((Object)Beans.get(AppRepository.class));
        ArrayList<App> appList = new ArrayList<App>();
        for (Map appData : apps) {
            App app = (App)((Object)appRepository.find(Long.parseLong(appData.get("id").toString())));
            appList.add(app);
        }
        ((AppService)Beans.get(AppService.class)).bulkInstall(appList, importDemo, language);
        response.setFlash(I18n.get((String)"Apps installed successfully"));
        response.setSignal("refresh-app", (Object)true);
    }

    public void refreshApp(ActionRequest request, ActionResponse response) {
        try {
            ((AppService)Beans.get(AppService.class)).refreshApp();
            response.setNotify(I18n.get((String)"Apps refreshed successfully"));
            response.setReload(true);
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
            response.setNotify(I18n.get((String)"Error in refreshing app"));
        }
    }

    public void generateAccessTemplate(ActionRequest request, ActionResponse response) throws AxelorException {
        MetaFile accesssFile = ((AccessTemplateService)Beans.get(AccessTemplateService.class)).generateTemplate();
        if (accesssFile == null) {
            return;
        }
        response.setView(ActionView.define((String)I18n.get((String)"Export file")).model(App.class.getName()).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + accesssFile.getId() + "/content/download?v=" + accesssFile.getVersion()).param("download", "true").map());
    }

    public void importRoles(ActionRequest request, ActionResponse response) throws AxelorException {
        App app = (App)((Object)request.getContext().asType(App.class));
        app = (App)((Object)((AppRepository)((Object)Beans.get(AppRepository.class))).find(app.getId()));
        ((AppService)Beans.get(AppService.class)).importRoles(app);
        response.setReload(true);
        response.setFlash(I18n.get((String)"Roles imported successfully"));
    }

    public void importAllRoles(ActionRequest request, ActionResponse response) throws AxelorException {
        ((AppService)Beans.get(AppService.class)).importRoles();
        response.setFlash(I18n.get((String)"Roles imported successfully"));
        response.setReload(true);
    }

    public void importAccessConfig(ActionRequest request, ActionResponse response) throws AxelorException {
        Map metaFileMap = (Map)request.getContext().get((Object)"metaFile");
        if (metaFileMap != null) {
            Long fileId = Long.parseLong(metaFileMap.get("id").toString());
            ((AccessConfigImportService)Beans.get(AccessConfigImportService.class)).importAccessConfig((MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).find(fileId));
            response.setFlash(I18n.get((String)"Access config imported successfully"));
            response.setCanClose(true);
        }
    }
}

