/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.ObjectDataConfig;
import com.axelor.apps.base.db.ObjectDataConfigExport;
import com.axelor.apps.base.db.repo.ObjectDataConfigRepository;
import com.axelor.apps.base.service.ObjectDataAnonymizeService;
import com.axelor.apps.base.service.ObjectDataExportService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;

public class ObjectDataExportController {
    public void export(ActionRequest request, ActionResponse response) throws AxelorException {
        ObjectDataConfigExport objDataConfigExport = (ObjectDataConfigExport)((Object)request.getContext().asType(ObjectDataConfigExport.class));
        Long objectDataconfigId = objDataConfigExport.getObjectDataConfig().getId();
        ObjectDataConfig objectDataConfig = (ObjectDataConfig)((Object)((ObjectDataConfigRepository)((Object)Beans.get(ObjectDataConfigRepository.class))).find(objectDataconfigId));
        MetaFile dataFile = ((ObjectDataExportService)Beans.get(ObjectDataExportService.class)).export(objectDataConfig, objDataConfigExport);
        if (dataFile != null) {
            response.setView(ActionView.define((String)I18n.get((String)"Data")).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + dataFile.getId() + "/content/download?v=" + dataFile.getVersion()).param("download", "true").map());
        }
        response.setCanClose(true);
    }

    public void anonymize(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        Long recordId = Long.parseLong(context.get((Object)"modelSelectId").toString());
        Long objectDataconfigId = Long.parseLong(context.get((Object)"objectDataConfigId").toString());
        ObjectDataConfig objectDataConfig = (ObjectDataConfig)((Object)((ObjectDataConfigRepository)((Object)Beans.get(ObjectDataConfigRepository.class))).find(objectDataconfigId));
        ((ObjectDataAnonymizeService)Beans.get(ObjectDataAnonymizeService.class)).anonymize(objectDataConfig, recordId);
        response.setFlash("Data anonymized successfully");
        response.setCanClose(true);
    }
}

