/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.db;

import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="AUTH_PERMISSION_ASSISTANT", indexes={@Index(columnList="meta_field"), @Index(columnList="meta_file")})
public class PermissionAssistant
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AUTH_PERMISSION_ASSISTANT_SEQ")
    @SequenceGenerator(name="AUTH_PERMISSION_ASSISTANT_SEQ", sequenceName="AUTH_PERMISSION_ASSISTANT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Import date", readonly=true)
    private LocalDateTime importDate;
    @Widget(title="Type")
    @NotNull
    private Integer typeSelect = 0;
    @Widget(title="User field")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaField metaField;
    @Widget(title="File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile metaFile;
    @Widget(title="Roles")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Role> roleSet;
    @Widget(title="Groups")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Group> groupSet;
    @Widget(title="Objects")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<MetaModel> objectSet;
    @Widget(title="Language", selection="select.language")
    private String language = "en";
    @Widget(title="Log")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String log;
    @Widget(title="Field permission")
    private Boolean fieldPermission = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDateTime getImportDate() {
        return this.importDate;
    }

    public void setImportDate(LocalDateTime importDate) {
        this.importDate = importDate;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public MetaField getMetaField() {
        return this.metaField;
    }

    public void setMetaField(MetaField metaField) {
        this.metaField = metaField;
    }

    public MetaFile getMetaFile() {
        return this.metaFile;
    }

    public void setMetaFile(MetaFile metaFile) {
        this.metaFile = metaFile;
    }

    public Set<Role> getRoleSet() {
        return this.roleSet;
    }

    public void setRoleSet(Set<Role> roleSet) {
        this.roleSet = roleSet;
    }

    public void addRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            this.setRoleSet(new HashSet<Role>());
        }
        this.getRoleSet().add(item);
    }

    public void removeRoleSetItem(Role item) {
        if (this.getRoleSet() == null) {
            return;
        }
        this.getRoleSet().remove(item);
    }

    public void clearRoleSet() {
        if (this.getRoleSet() != null) {
            this.getRoleSet().clear();
        }
    }

    public Set<Group> getGroupSet() {
        return this.groupSet;
    }

    public void setGroupSet(Set<Group> groupSet) {
        this.groupSet = groupSet;
    }

    public void addGroupSetItem(Group item) {
        if (this.getGroupSet() == null) {
            this.setGroupSet(new HashSet<Group>());
        }
        this.getGroupSet().add(item);
    }

    public void removeGroupSetItem(Group item) {
        if (this.getGroupSet() == null) {
            return;
        }
        this.getGroupSet().remove(item);
    }

    public void clearGroupSet() {
        if (this.getGroupSet() != null) {
            this.getGroupSet().clear();
        }
    }

    public Set<MetaModel> getObjectSet() {
        return this.objectSet;
    }

    public void setObjectSet(Set<MetaModel> objectSet) {
        this.objectSet = objectSet;
    }

    public void addObjectSetItem(MetaModel item) {
        if (this.getObjectSet() == null) {
            this.setObjectSet(new HashSet<MetaModel>());
        }
        this.getObjectSet().add(item);
    }

    public void removeObjectSetItem(MetaModel item) {
        if (this.getObjectSet() == null) {
            return;
        }
        this.getObjectSet().remove(item);
    }

    public void clearObjectSet() {
        if (this.getObjectSet() != null) {
            this.getObjectSet().clear();
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLog() {
        return this.log;
    }

    public void setLog(String log) {
        this.log = log;
    }

    public Boolean getFieldPermission() {
        return this.fieldPermission == null ? Boolean.FALSE : this.fieldPermission;
    }

    public void setFieldPermission(Boolean fieldPermission) {
        this.fieldPermission = fieldPermission;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PermissionAssistant)) {
            return false;
        }
        PermissionAssistant other = (PermissionAssistant)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("importDate", (Object)this.getImportDate()).add("typeSelect", (Object)this.getTypeSelect()).add("language", (Object)this.getLanguage()).add("fieldPermission", (Object)this.getFieldPermission()).omitNullValues().toString();
    }
}

