/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.auth.web;

import com.axelor.auth.db.PermissionAssistant;
import com.axelor.auth.db.repo.PermissionAssistantRepository;
import com.axelor.auth.service.PermissionAssistantService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;

@Singleton
public class PermissionAssistantController {
    public void createFile(ActionRequest request, ActionResponse response) {
        try {
            Long permissionAssistantId = (Long)request.getContext().get((Object)"id");
            ((PermissionAssistantService)Beans.get(PermissionAssistantService.class)).createFile((PermissionAssistant)((Object)((PermissionAssistantRepository)((Object)Beans.get(PermissionAssistantRepository.class))).find(permissionAssistantId)));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void importPermissions(ActionRequest request, ActionResponse response) {
        try {
            Long permissionAssistantId = (Long)request.getContext().get((Object)"id");
            String errors = ((PermissionAssistantService)Beans.get(PermissionAssistantService.class)).importPermissions((PermissionAssistant)((Object)((PermissionAssistantRepository)((Object)Beans.get(PermissionAssistantRepository.class))).find(permissionAssistantId)));
            response.setValue("importDate", (Object)LocalDateTime.now());
            response.setValue("log", (Object)errors);
            if (errors.isEmpty()) {
                response.setFlash(I18n.get((String)"Import completed successfully"));
            } else {
                response.setFlash(I18n.get((String)"Error in import. Please check log."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillObjects(ActionRequest request, ActionResponse response) {
        try {
            PermissionAssistant assistant = (PermissionAssistant)((Object)request.getContext().asType(PermissionAssistant.class));
            MetaField metaField = assistant.getMetaField();
            if (metaField != null && (assistant.getObjectSet() == null || assistant.getObjectSet().isEmpty())) {
                List models = ((MetaModelRepository)Beans.get(MetaModelRepository.class)).all().filter("self.metaFields.relationship = 'ManyToOne' and self.metaFields.typeName = ?1", new Object[]{metaField.getTypeName()}).fetch();
                HashSet objectSet = new HashSet();
                objectSet.addAll(models);
                response.setValue("objectSet", objectSet);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

