/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.meta.service;

import com.axelor.auth.db.Group;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaGroupMenuAssistant;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.repo.MetaGroupMenuAssistantRepository;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaGroupMenuAssistantService {
    @Inject
    private MetaGroupMenuAssistantRepository menuAssistantRepository;
    @Inject
    private GroupRepository groupRepository;
    @Inject
    private MetaMenuRepository menuRepository;
    @Inject
    private RoleRepository roleRepository;
    @Inject
    private MetaFiles metaFiles;
    private List<String> badGroups = new ArrayList<String>();
    private List<String> badRoles = new ArrayList<String>();
    private String errorLog = "";
    private Set<MetaMenu> updatedMenus = Sets.newHashSet();
    private ResourceBundle bundle;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private String getFileName(MetaGroupMenuAssistant groupMenuAssistant) {
        String userCode = groupMenuAssistant.getCreatedBy().getCode();
        String dateString = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
        String fileName = "GroupMenu-" + userCode + "-" + dateString + ".csv";
        return fileName;
    }

    private void setBundle(Locale locale) {
        this.bundle = I18n.getBundle((Locale)locale);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = I18n.getBundle((Locale)new Locale("en"));
        }
        return this.bundle;
    }

    @Transactional(rollbackOn={Exception.class})
    public void createGroupMenuFile(MetaGroupMenuAssistant groupMenuAssistant) throws IOException {
        this.setBundle(new Locale(groupMenuAssistant.getLanguage()));
        File groupMenuFile = MetaFiles.createTempFile((String)"MenuGroup", (String)".csv", (FileAttribute[])new FileAttribute[0]).toFile();
        try {
            List<String[]> rows = this.createHeader(groupMenuAssistant);
            this.addMenuRows(groupMenuAssistant, rows);
            this.addGroupAccess(rows);
            try (CSVWriter csvWriter = new CSVWriter((Writer)new FileWriterWithEncoding(groupMenuFile, "utf-8"), ';');
                 FileInputStream fis = new FileInputStream(groupMenuFile);){
                csvWriter.writeAll(rows);
                groupMenuAssistant.setMetaFile(this.metaFiles.upload((InputStream)fis, this.getFileName(groupMenuAssistant)));
            }
            this.menuAssistantRepository.save((Model)((Object)groupMenuAssistant));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    private List<String[]> createHeader(MetaGroupMenuAssistant groupMenuAssistant) throws IOException {
        MetaFile metaFile = groupMenuAssistant.getMetaFile();
        List<Object> rows = new ArrayList<String[]>();
        if (metaFile != null) {
            File csvFile = MetaFiles.getPath((MetaFile)metaFile).toFile();
            logger.debug("File name: {}", (Object)csvFile.getAbsolutePath());
            logger.debug("File length: {}", (Object)csvFile.length());
            try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(csvFile), StandardCharsets.UTF_8), ';');){
                rows = csvReader.readAll();
                logger.debug("Rows size: {}", (Object)rows.size());
            }
        }
        if (!rows.isEmpty()) {
            rows.set(0, this.getGroupRow((String[])rows.get(0), groupMenuAssistant));
        } else {
            rows.add(this.getGroupRow(null, groupMenuAssistant));
        }
        return rows;
    }

    private String[] getGroupRow(String[] row, MetaGroupMenuAssistant groupMenuAssistant) throws IOException {
        ArrayList<String> groupList = new ArrayList<String>();
        if (row != null) {
            groupList.addAll(Arrays.asList(row));
        } else {
            groupList.add(this.getBundle().getString("Name"));
            groupList.add(this.getBundle().getString("Title"));
        }
        for (Group group : groupMenuAssistant.getGroupSet()) {
            String code = group.getCode();
            if (groupList.contains(code)) continue;
            groupList.add(code);
        }
        for (Role role : groupMenuAssistant.getRoleSet()) {
            String name = role.getName();
            if (groupList.contains(name)) continue;
            groupList.add(name);
        }
        return groupList.toArray(new String[groupList.size()]);
    }

    private void addMenuRows(MetaGroupMenuAssistant groupMenuAssistant, List<String[]> rows) {
        String[] groupRow = rows.get(0);
        rows.remove(0);
        HashSet<String> names = new HashSet<String>();
        for (String[] line : rows) {
            names.add(line[0]);
        }
        for (MetaMenu metaMenu : groupMenuAssistant.getMenuSet()) {
            String name = metaMenu.getName();
            if (names.contains(name)) continue;
            String title = metaMenu.getTitle();
            String translation = this.getBundle().getString(title);
            if (!Strings.isNullOrEmpty((String)translation)) {
                title = translation;
            }
            String[] menu = new String[groupRow.length];
            menu[0] = name;
            menu[1] = title;
            rows.add(menu);
        }
        Collections.sort(rows, new Comparator<String[]>(){

            @Override
            public int compare(String[] first, String[] second) {
                return first[0].compareTo(second[0]);
            }
        });
        rows.add(0, groupRow);
    }

    private void addGroupAccess(List<String[]> rows) {
        ListIterator<String[]> rowIter = rows.listIterator();
        String[] header = rowIter.next();
        while (rowIter.hasNext()) {
            String[] row = rowIter.next();
            MetaMenu menu = (MetaMenu)this.menuRepository.all().filter("self.name = ?1", new Object[]{row[0]}).order("-priority").fetchOne();
            if (row.length < header.length) {
                row = Arrays.copyOf(row, header.length);
                rowIter.set(row);
            }
            for (int i = 2; i < header.length; ++i) {
                for (Group group : menu.getGroups()) {
                    if (header[i] == null || !header[i].equals(group.getCode())) continue;
                    row[i] = "x";
                }
                for (Role role : menu.getRoles()) {
                    if (header[i] == null || !header[i].equals(role.getName())) continue;
                    row[i] = "x";
                }
            }
        }
    }

    private Map<String, Object> checkGroups(String[] groupRow) {
        HashMap<String, Object> groupMap = new HashMap<String, Object>();
        Integer glen = 2;
        while (glen < groupRow.length) {
            Group group = (Group)this.groupRepository.all().filter("self.code = ?1", new Object[]{groupRow[glen]}).fetchOne();
            if (group == null) {
                this.badGroups.add(groupRow[glen]);
            } else {
                groupMap.put(groupRow[glen], group);
            }
            Integer n = glen;
            Integer n2 = glen = Integer.valueOf(glen + 1);
        }
        return groupMap;
    }

    private Map<String, Role> checkRoles(String[] roleRow) {
        HashMap<String, Role> roleMap = new HashMap<String, Role>();
        Integer rlen = 2;
        while (rlen < roleRow.length) {
            Role role = (Role)this.roleRepository.all().filter("self.name = ?1", new Object[]{roleRow[rlen]}).fetchOne();
            if (role == null) {
                this.badRoles.add(roleRow[rlen]);
            } else {
                roleMap.put(roleRow[rlen], role);
            }
            Integer n = rlen;
            Integer n2 = rlen = Integer.valueOf(rlen + 1);
        }
        return roleMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String importGroupMenu(MetaGroupMenuAssistant groupMenuAssistant) {
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(MetaFiles.getPath((MetaFile)groupMenuAssistant.getMetaFile()).toFile()), StandardCharsets.UTF_8), ';');){
            this.setBundle(new Locale(groupMenuAssistant.getLanguage()));
            String[] groupRow = csvReader.readNext();
            if (groupRow == null || groupRow.length < 3) {
                String string = I18n.get((String)"Bad import file");
                return string;
            }
            Map<String, Object> groupMap = this.checkGroups(groupRow);
            groupMap.putAll(this.checkRoles(groupRow));
            this.badGroups.removeAll(groupMap.keySet());
            this.badRoles.removeAll(groupMap.keySet());
            if (!this.badGroups.isEmpty()) {
                this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Groups not found: %s"), this.badGroups);
            }
            if (!this.badRoles.isEmpty()) {
                this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Roles not found: %s"), this.badRoles);
            }
            Group admin = this.groupRepository.findByCode("admins");
            for (String[] row : csvReader.readAll()) {
                this.importMenus(row, groupRow, groupMap, admin);
            }
            this.saveMenus();
            return this.errorLog;
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Error in import: %s. Please check the server log"), e.getMessage());
        }
        return this.errorLog;
    }

    @Transactional
    public void saveMenus() {
        for (MetaMenu menu : this.updatedMenus) {
            this.menuRepository.save((Model)menu);
        }
    }

    private void importMenus(String[] row, String[] groupRow, Map<String, Object> groupMap, Group admin) throws IOException {
        List menus = this.menuRepository.all().filter("self.name = ?1", new Object[]{row[0]}).order("-priority").fetch();
        if (menus.isEmpty()) {
            this.errorLog = this.errorLog + "\n" + String.format(I18n.get((String)"Menu not found: %s"), row[0]);
            return;
        }
        for (MetaMenu menu : menus) {
            boolean noAccess = true;
            Integer mIndex = 2;
            while (mIndex < row.length) {
                String code = groupRow[mIndex];
                Object object = groupMap.get(code);
                Role role = null;
                Group group = null;
                if (object instanceof Group) {
                    group = (Group)object;
                } else if (object instanceof Role) {
                    role = (Role)object;
                }
                if (row[mIndex].equalsIgnoreCase("x")) {
                    noAccess = false;
                    if (group != null) {
                        menu.addGroup(group);
                    }
                    if (role != null) {
                        menu.addRole(role);
                    }
                    this.updatedMenus.add(menu);
                } else if (group != null && menu.getGroups().contains(group)) {
                    menu.removeGroup(group);
                    this.updatedMenus.add(menu);
                } else if (role != null && menu.getRoles().contains(role)) {
                    menu.removeRole(role);
                    this.updatedMenus.add(menu);
                }
                Integer n = mIndex;
                Integer n2 = mIndex = Integer.valueOf(mIndex + 1);
            }
            if (!noAccess || admin == null) continue;
            menu.addGroup(admin);
        }
    }
}

