/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher;

import dorkbox.util.OS;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public class Settings {
    private static final String CONFIG_FILE_NAME = "application.properties";
    private static final String DATABASE_NAME = "axelor";
    private static final String DATABASE_USER = "axelor";
    public static final int DEFAULT_TOMCAT_PORT = 8080;
    public static final int DEFAULT_DATABASE_PORT = 5433;
    public static final String DEFAULT_DATABASE_PASSWORD = "s3cr@t";
    private static Settings instance;
    private final Path baseConfigFile = Settings.findBaseConfigFile();
    private final Path userConfigFile;
    private final Properties baseConfig = Settings.load(this.baseConfigFile);
    private final Properties userConfig;
    private String appName = this.baseConfig.getProperty("application.name");
    private String appVersion = this.baseConfig.getProperty("application.version");
    private String appDescription = this.baseConfig.getProperty("application.description");

    private Settings() {
        this.userConfigFile = Settings.getAppDataDir(this.appName, this.appVersion).resolve(CONFIG_FILE_NAME).toAbsolutePath();
        this.userConfig = this.copyConfig(this.baseConfigFile, this.userConfigFile);
        if (Files.notExists(this.baseConfigFile, new LinkOption[0])) {
            throw new RuntimeException("Unable to find application configuration.");
        }
    }

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    private static Path findBasePath() {
        try {
            Class<?> klass = Class.forName("com.apple.eio.FileManager");
            Method method = klass.getDeclaredMethod("getPathToApplicationBundle", new Class[0]);
            String result = (String)method.invoke(null, new Object[0]);
            return Paths.get(result, "../../..").normalize();
        }
        catch (Exception exception) {
            return Paths.get(".", new String[0]).toAbsolutePath().normalize();
        }
    }

    private static Path findBaseConfigFile() {
        Path basePath = Settings.findBasePath();
        return Stream.of("etc", "../etc").map(dir -> basePath.resolve((String)dir).resolve(CONFIG_FILE_NAME).normalize()).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(Path::toAbsolutePath).orElse(null);
    }

    private static Properties load(Path config) {
        Properties properties = new Properties();
        try (FileReader reader = new FileReader(config.toFile());){
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read config file: " + config);
        }
        return properties;
    }

    private static Path getAppDataDir(String appName, String appVersion) {
        if (OS.isMacOsX()) {
            Path dir = Paths.get(System.getProperty("user.home"), "Library", "Application Support");
            return dir.resolve(Paths.get("Axelor", appName, appVersion));
        }
        return Settings.findBasePath().resolve(Paths.get("var", "data"));
    }

    private Properties copyConfig(Path source, Path target) {
        if (Files.notExists(target, new LinkOption[0])) {
            try {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(source, target, new CopyOption[0]);
                this.update(8080, 5433, DEFAULT_DATABASE_PASSWORD, null, null, true);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create config file: " + target);
            }
        }
        try {
            this.update(-1, -1, null, null, null, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update config file: " + target);
        }
        return Settings.load(target);
    }

    public Path getAppDataDir() {
        return this.userConfigFile.getParent();
    }

    public Path getAppDir() {
        return this.baseConfigFile.getParent().getParent();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getAppDescription() {
        return this.appDescription;
    }

    public String getAppLink() {
        return String.format("http://localhost:%s", this.getWebPort());
    }

    public String getAppLanguage() {
        return this.userConfig.getProperty("application.locale", Locale.getDefault().getLanguage());
    }

    public String getAppTheme() {
        return this.userConfig.getProperty("application.theme", "default");
    }

    public int getWebPort() {
        return this.getInt("tomcat.http.port", 8080);
    }

    public int getDatabasePort() {
        return this.getInt("database.port", 5433);
    }

    public String getDatabaseName() {
        return "axelor";
    }

    public String getDatabaseUser() {
        return "axelor";
    }

    public String getDatabasePassword() {
        return this.userConfig.getProperty("db.default.password", DEFAULT_DATABASE_PASSWORD);
    }

    public String get(String key) {
        return this.userConfig.getProperty(key);
    }

    public String get(String key, String defaultValue) {
        return this.userConfig.getProperty(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.userConfig.getProperty(key);
        try {
            return Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.userConfig.getProperty(key);
        try {
            return Boolean.parseBoolean(value.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void updateDDL(String mode) {
        String current = this.userConfig.getProperty("db.default.ddl");
        if (Objects.equals(current, Objects.requireNonNull(mode))) {
            return;
        }
        try {
            String content = FileUtils.readFileToString(this.userConfigFile.toFile(), StandardCharsets.UTF_8);
            content = content.replaceAll("db.default.ddl = .*", "db.default.ddl = " + mode);
            FileUtils.write(this.userConfigFile.toFile(), (CharSequence)content, StandardCharsets.UTF_8);
            this.userConfig.setProperty("db.default.ddl", "update");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int findNextPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private String set(String text, String key, Object value) {
        Pattern pattern;
        Matcher matcher;
        Object val = value;
        if (val instanceof Path) {
            val = ((Path)val).toAbsolutePath().normalize().toFile().getPath().replace("\\", "/");
        }
        if (!(matcher = (pattern = Pattern.compile("^\\s*" + key + "\\s*=.*", 8)).matcher(text)).find()) {
            pattern = Pattern.compile("^\\s*#\\s*" + key + "\\s*=.*", 8);
            matcher = pattern.matcher(text);
        }
        return matcher.replaceAll(key + " = " + (val == null ? "" : val));
    }

    public synchronized void update(int httpPort, int dbPort, String dbPass, String lang, String theme, boolean fixPaths) throws IOException {
        File configFile = this.userConfigFile.toFile();
        Path dataDir = this.userConfigFile.getParent();
        String content = FileUtils.readFileToString(configFile, StandardCharsets.UTF_8).trim();
        if (dbPort > -1) {
            String connection = String.format("jdbc:postgresql://localhost:%s/axelor", dbPort);
            content = this.set(content, "db.default.url", connection);
            content = this.set(content, "db.default.user", "axelor");
        }
        if (dbPass != null) {
            content = this.set(content, "db.default.password", dbPass);
        }
        if (fixPaths) {
            content = this.set(content, "logging.path", dataDir.resolve("logs"));
            content = this.set(content, "file.upload.dir", dataDir.resolve("upload"));
            content = this.set(content, "reports.design.dir", dataDir.resolve("reports"));
            content = this.set(content, "reports.output.dir", dataDir.resolve("reports-gen"));
            content = this.set(content, "data.export.dir", dataDir.resolve("export"));
            content = this.set(content, "template.search.dir", dataDir.resolve("templates"));
            content = this.set(content, "hibernate.search.default.indexBase", dataDir.resolve("indexes"));
            content = this.set(content, "application.locale", Locale.getDefault().getLanguage());
        }
        if (lang != null) {
            content = this.set(content, "application.locale", lang);
        }
        if (theme != null) {
            content = this.set(content, "application.theme", theme);
        }
        if (httpPort > -1) {
            if (content.indexOf("tomcat.http.port") > -1) {
                content = this.set(content, "tomcat.http.port", httpPort);
            } else {
                content = content + "\n";
                content = content + "tomcat.http.port = " + httpPort;
                content = content + "\n";
                content = content + "tomcat.https.port = " + this.findNextPort();
                content = content + "\n";
                content = content + "tomcat.ajp.port = " + this.findNextPort();
                content = content + "\n";
                content = content + "tomcat.shutdown.port = " + this.findNextPort();
                content = content + "\n";
            }
        }
        if (dbPort > -1) {
            if (content.indexOf("database.port") > -1) {
                content = this.set(content, "database.port", dbPort);
            } else {
                content = content + "\n";
                content = content + "\ndatabase.port = " + dbPort;
                content = content + "\n";
            }
        }
        content = content + "\n";
        FileUtils.write(configFile, (CharSequence)content, StandardCharsets.UTF_8);
        if (this.userConfig != null) {
            this.userConfig.setProperty("tomcat.http.port", "" + httpPort);
            this.userConfig.setProperty("database.port", "" + dbPort);
        }
    }
}

