/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.Settings;
import dorkbox.util.OS;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CommandContext {
    public final Settings settings = Settings.getInstance();
    private final Map<String, String> environment = new HashMap<String, String>();
    public final Path baseDir = this.settings.getAppDir();
    public final Path dataDir = this.settings.getAppDataDir();
    public final Path pgHome = this.fromBase("opt", "pgsql");
    public final Path pgData = this.fromData("postgresql", new String[0]);
    public final String dbUser = this.settings.getDatabaseUser();
    public final String dbPass = this.settings.getDatabasePassword();
    public final String pgUser = "postgres";
    public final String pgPass = this.dbPass;
    public final Path pgPassFile = this.resolve(this.pgData, "pgpass.conf", new String[0]);
    public final Path pgPassText = this.resolve(this.dataDir, "pgpass.txt", new String[0]);
    public final Path pgRestoreFile = this.resolve(this.dataDir, "db-restore.dump", new String[0]);
    public final Path pgMigrateFile = this.resolve(this.dataDir, "db-migrate.sql", new String[0]);
    public final Path javaHome = this.fromBase("opt", "jdk");
    public final Path tomcatHome = this.fromBase("opt", "tomcat");
    public final Path tomcatBase = this.fromData("tomcat", new String[0]);
    public final String binCatalina = this.resolve(this.tomcatHome, "bin", OS.isWindows() ? "catalina.bat" : "catalina.sh").toString();
    public final String binPgCtl = this.resolve(this.pgHome, "bin", "pg_ctl").toString();
    public final String binPsql = this.resolve(this.pgHome, "bin", "psql").toString();
    public final String binInitDb = this.resolve(this.pgHome, "bin", "initdb").toString();
    public final String binCreatedb = this.resolve(this.pgHome, "bin", "createdb").toString();
    public final String binPgRestore = this.resolve(this.pgHome, "bin", "pg_restore").toString();
    private static CommandContext instance;

    private CommandContext() {
    }

    public static CommandContext getInstance() {
        if (instance == null) {
            instance = new CommandContext();
        }
        return instance;
    }

    public Path fromBase(String first, String ... more) {
        return this.resolve(this.baseDir, first, more);
    }

    public Path fromData(String first, String ... more) {
        return this.resolve(this.dataDir, first, more);
    }

    public Path resolve(Path from, String next, String ... more) {
        return from.resolve(Paths.get(next, more));
    }

    private static String quote(Path path) {
        return CommandContext.quote(path.toString());
    }

    private static String quote(String argument) {
        if (argument == null || argument.indexOf(" ") == -1 || argument.indexOf("\"") == 0 || argument.indexOf("'") == 0) {
            return argument;
        }
        return "\"" + argument + "\"";
    }

    private static String envPath(Path ... prepend) {
        StringBuilder builder = new StringBuilder();
        Iterator<Path> iter = Arrays.asList(prepend).iterator();
        while (iter.hasNext()) {
            builder.append(File.pathSeparator).append(CommandContext.quote(iter.next().toString()));
        }
        builder.append(File.pathSeparator).append(System.getenv("PATH"));
        return builder.toString();
    }

    public synchronized void clear() {
        this.environment.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> environment() {
        if (!this.environment.isEmpty()) {
            return this.environment;
        }
        CommandContext commandContext = this;
        synchronized (commandContext) {
            Map<String, String> env = this.environment;
            String path = CommandContext.envPath(this.javaHome.resolve("bin"), this.tomcatHome.resolve("bin"), this.pgHome.resolve("bin"));
            env.putAll(System.getenv());
            env.put("PATH", path);
            env.put("PGHOME", this.pgHome.toString());
            env.put("PGDATA", this.dataDir.relativize(this.pgData).toString());
            env.put("PGHOST", "localhost");
            env.put("PGPORT", "" + this.settings.getDatabasePort());
            env.put("PGPASSFILE", this.dataDir.relativize(this.pgPassFile).toString());
            env.put("CATALINA_HOME", this.tomcatHome.toString());
            env.put("CATALINA_BASE", this.tomcatBase.toString());
            env.put("CATALINA_TMPDIR", this.fromData("tmp", new String[0]).toString());
            env.put("JAVA_HOME", this.javaHome.toString());
            env.put("JRE_HOME", this.javaHome.resolve("jre").toString());
            StringBuilder opts = new StringBuilder();
            opts.append(this.settings.get("java.opts", ""));
            opts.append(" ").append("-Dfile.encoding=UTF-8");
            opts.append(" ").append("-Dapp.config=").append(CommandContext.quote(this.fromData("application.properties", new String[0])));
            opts.append(" ").append("-Daxelor.config=").append(CommandContext.quote(this.fromData("application.properties", new String[0])));
            opts.append(" ").append("-Dtomcat.app.base=").append(CommandContext.quote(this.fromBase("var", "www")));
            opts.append(" ").append("-Dtomcat.http.port=").append(this.settings.getWebPort());
            opts.append(" ").append("-Dtomcat.https.port=").append(this.settings.getInt("tomcat.https.port", 8443));
            opts.append(" ").append("-Dtomcat.ajp.port=").append(this.settings.getInt("tomcat.ajp.port", 8009));
            opts.append(" ").append("-Dtomcat.shutdown.port=").append(this.settings.getInt("tomcat.shutdown.port", 8005));
            env.put("JAVA_OPTS", opts.toString().trim());
            return env;
        }
    }
}

