/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.command;

import com.axelor.launcher.command.AbstractService;
import com.axelor.launcher.command.CallableWorker;
import com.axelor.launcher.command.Command;
import com.axelor.launcher.command.CommandContext;
import com.axelor.launcher.command.ServiceStatus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class TomcatService
extends AbstractService {
    private static final String WAIT_FOR_TOMCAT_START = "Server startup in";
    private final CommandContext context = CommandContext.getInstance();
    private final boolean initialized;
    private final Command cmdStart;
    private final Command cmdStop;

    public TomcatService() {
        this.cmdStart = new Command(this.context.binCatalina, "run");
        this.cmdStop = new Command(this.context.binCatalina, "stop");
        this.cmdStart.addErrConsumer(this::publish);
        this.initialized = Files.exists(this.context.resolve(this.context.tomcatBase, "conf", "server.xml"), new LinkOption[0]);
    }

    private void init() {
        Path tomcatBase = this.context.tomcatBase;
        Path tomcatHome = this.context.tomcatHome;
        if (this.initialized) {
            return;
        }
        Path tomcatHomeConf = tomcatHome.resolve("conf");
        Path tomcatBaseConf = tomcatBase.resolve("conf");
        Path tomcatXml = this.context.fromBase("etc", "tomcat.xml");
        try {
            Files.createDirectories(this.context.fromData("tmp", new String[0]), new FileAttribute[0]);
            Files.createDirectories(tomcatBase.resolve("lib"), new FileAttribute[0]);
            Files.createDirectories(tomcatBase.resolve("conf"), new FileAttribute[0]);
            Files.createDirectories(tomcatBase.resolve("logs"), new FileAttribute[0]);
            FileUtils.copyDirectory(tomcatHomeConf.toFile(), tomcatBaseConf.toFile());
            FileUtils.copyFile(tomcatXml.toFile(), this.context.resolve(tomcatBase, "conf", "server.xml").toFile());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void start() {
        this.setStatus(ServiceStatus.STARTING);
        CallableWorker.execute(() -> {
            this.init();
            this.cmdStop.call();
            return this.cmdStart.call();
        });
    }

    @Override
    public void stop() {
        this.setStatus(ServiceStatus.STOPPING);
        CallableWorker.execute(() -> {
            Integer res = this.cmdStop.call();
            this.setStatus(ServiceStatus.STOPPED);
            return res;
        });
    }

    @Override
    protected void publish(String line) {
        super.publish(line);
        if (line.contains(WAIT_FOR_TOMCAT_START)) {
            this.setStatus(ServiceStatus.STARTED);
        }
    }
}

