/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.gui;

import com.axelor.launcher.Settings;
import com.axelor.launcher.command.AbstractService;
import com.axelor.launcher.command.CommandContext;
import com.axelor.launcher.command.ServiceStatus;
import com.axelor.launcher.gui.SettingsPanel;
import com.axelor.launcher.gui.StatusPanel;
import com.axelor.launcher.gui.SwingUtils;
import com.axelor.launcher.i18n.Names;
import dorkbox.util.OS;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public final class Launcher
extends JFrame
implements Names {
    private static final long serialVersionUID = 7907806922293297904L;
    private static final String STATUS_PANEL = "status";
    private static final String SETTINGS_PANEL = "settings";
    private JButton btnSettingsShow;
    private JButton btnSettingsCancel;
    private JButton btnSettingsApply;
    private JButton btnStart;
    private JButton btnStop;
    private JButton btnOpen;
    private JButton btnHide;
    private JPanel contentPanel;
    private StatusPanel statusPanel;
    private SettingsPanel settingsPanel;
    private String currentPanel;
    private final AbstractService service;
    private final Settings settings;
    private boolean initialized;

    public Launcher(Settings settings, AbstractService service) {
        this.settings = settings;
        this.service = service;
        this.initialized = Files.exists(CommandContext.getInstance().pgPassFile, new LinkOption[0]);
        ArrayList<Image> icons = new ArrayList<Image>();
        icons.add(SwingUtils.getImage("/images/icon.png"));
        icons.add(SwingUtils.getImage("/images/icon@2x.png"));
        icons.add(SwingUtils.getImage("/images/icon@4x.png"));
        this.setTitle(settings.getAppName());
        this.setIconImages(icons);
        this.createHeader();
        this.createContent();
        this.createFooter();
        this.showStatus();
        this.pack();
        this.setLocationRelativeTo(null);
        this.setMinimumSize(new Dimension(580, this.getHeight()));
        service.changed(status -> {
            this.update();
            if (status == ServiceStatus.STARTING) {
                this.statusPanel.clear();
            }
            if (status == ServiceStatus.STARTED) {
                this.initialized = true;
            }
        });
        service.addErrConsumer(line -> this.statusPanel.log((String)line));
    }

    private void createHeader() {
        JPanel headerPane = new JPanel(new BorderLayout(0, 0));
        this.getContentPane().add((Component)headerPane, "North");
        Box headerBox = Box.createVerticalBox();
        headerBox.setBorder(new EmptyBorder(16, 16, 16, 16));
        headerPane.add((Component)headerBox, "Center");
        JLabel appLogo = new JLabel(SwingUtils.getIcon("/images/logo.png"));
        JLabel appName = new JLabel(this.settings.getAppName() + " " + this.settings.getAppVersion());
        JLabel appTitle = new JLabel(this.settings.getAppDescription());
        appName = SwingUtils.makeBold(appName, 4.0f);
        headerBox.add(appName);
        headerBox.add(Box.createVerticalStrut(4));
        headerBox.add(appTitle);
        headerPane.add((Component)appLogo, "East");
        headerPane.add((Component)new JSeparator(), "South");
    }

    private void createFooter() {
        JPanel footerPane = new JPanel(new BorderLayout(0, 0));
        this.getContentPane().add((Component)footerPane, "South");
        footerPane.add((Component)new JSeparator(), "North");
        Box buttonsBox = Box.createHorizontalBox();
        buttonsBox.setBorder(new EmptyBorder(10, 10, 10, 10));
        footerPane.add((Component)buttonsBox, "Center");
        this.btnSettingsShow = new JButton(BTN_SETTINGS_TITLE);
        this.btnSettingsCancel = new JButton(BTN_SETTINGS_CANCEL_TITLE);
        this.btnSettingsApply = new JButton(BTN_SETTINGS_APPLY_TITLE);
        this.btnStart = new JButton(BTN_START_TITLE);
        this.btnStop = new JButton(BTN_STOP_TITLE);
        this.btnOpen = new JButton(BTN_OPEN_TITLE);
        this.btnHide = new JButton(BTN_HIDE_TITLE);
        this.btnSettingsShow.addActionListener(e -> this.showSettings());
        this.btnSettingsCancel.addActionListener(e -> this.showStatus());
        this.btnSettingsApply.addActionListener(this::onApplySettings);
        this.btnStart.addActionListener(this::onStart);
        this.btnStop.addActionListener(this::onStop);
        this.btnOpen.addActionListener(this::onOpen);
        this.btnHide.addActionListener(this::onHide);
        buttonsBox.add(this.btnOpen);
        buttonsBox.add(this.btnHide);
        buttonsBox.add(this.btnSettingsShow);
        buttonsBox.add(Box.createHorizontalGlue());
        buttonsBox.add(this.btnStart);
        buttonsBox.add(this.btnStop);
        buttonsBox.add(this.btnSettingsCancel);
        buttonsBox.add(this.btnSettingsApply);
    }

    private void createContent() {
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.contentPanel.setLayout(new CardLayout());
        this.statusPanel = new StatusPanel();
        this.settingsPanel = new SettingsPanel();
        this.contentPanel.add((Component)this.statusPanel, STATUS_PANEL);
        this.contentPanel.add((Component)this.settingsPanel, SETTINGS_PANEL);
        this.settingsPanel.addDataDirHandler(e -> {
            if (OS.isWindows()) {
                this.service.open("", this.settings.getAppDataDir().toString());
            } else {
                this.service.open(this.settings.getAppDataDir().toString());
            }
        });
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.resetSettings();
    }

    private void resetSettings() {
        this.settingsPanel.setWebPort(this.settings.getWebPort());
        this.settingsPanel.setDatabasePort(this.settings.getDatabasePort());
        this.settingsPanel.setDatabasePassword(this.settings.getDatabasePassword());
        this.settingsPanel.setDataDirectory(this.settings.getAppDataDir().toString());
        this.settingsPanel.setLanguage(this.settings.getAppLanguage());
        this.settingsPanel.setTheme(this.settings.getAppTheme());
        this.settingsPanel.setAllowPasswordChange(!this.isInitialized());
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private void onStart(ActionEvent e) {
        this.service.start();
    }

    private void onStop(ActionEvent e) {
        this.service.stop();
    }

    private void onOpen(ActionEvent e) {
        this.service.open(this.settings.getAppLink());
    }

    private void onHide(ActionEvent e) {
        this.setVisible(false);
    }

    private void update() {
        switch (this.currentPanel) {
            case "settings": {
                this.btnStart.setVisible(false);
                this.btnStop.setVisible(false);
                this.btnOpen.setVisible(false);
                this.btnHide.setVisible(false);
                this.btnSettingsShow.setVisible(false);
                this.btnSettingsCancel.setVisible(true);
                this.btnSettingsApply.setVisible(true);
                this.settingsPanel.setAllowPasswordChange(!this.initialized);
                break;
            }
            case "status": {
                this.btnStart.setVisible(true);
                this.btnStop.setVisible(true);
                this.btnStart.setEnabled(this.service.canStart());
                this.btnStop.setEnabled(this.service.canStop());
                this.btnOpen.setVisible(this.service.canStop());
                this.btnHide.setVisible(this.service.canStop());
                this.btnSettingsShow.setVisible(this.service.canStart());
                this.btnSettingsCancel.setVisible(false);
                this.btnSettingsApply.setVisible(false);
            }
        }
    }

    private void show(String panel) {
        this.currentPanel = panel;
        ((CardLayout)this.contentPanel.getLayout()).show(this.contentPanel, panel);
        this.update();
    }

    private void onApplySettings(ActionEvent e) {
        String pass1 = this.settingsPanel.getDatabasePassword();
        String pass2 = this.settingsPanel.getDatabasePasswordConfirm();
        if (pass1 == null || pass1.trim().length() < 4) {
            JOptionPane.showMessageDialog(this, MESSAGE_PASSWORD_INVALID, ERROR_TITLE, 0);
            return;
        }
        if (!pass1.equals(pass2)) {
            JOptionPane.showMessageDialog(this, MESSAGE_PASSWORD_MISMATCH, ERROR_TITLE, 0);
            return;
        }
        int wsPort = this.settingsPanel.getWebPort();
        int dbPort = this.settingsPanel.getDatabasePort();
        String lang = this.settingsPanel.getLanguage();
        String theme = this.settingsPanel.getTheme();
        try {
            this.settings.update(wsPort, dbPort, pass1, lang, theme, false);
            CommandContext.getInstance().clear();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, MESSAGE_SETTINGS_ERROR, ERROR_TITLE, 0);
            this.resetSettings();
        }
        this.showStatus();
    }

    public void showSettings() {
        this.show(SETTINGS_PANEL);
    }

    public void showStatus() {
        this.show(STATUS_PANEL);
    }
}

