/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.gui;

import com.axelor.launcher.i18n.Names;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public final class SettingsPanel
extends JPanel
implements Names {
    private static final long serialVersionUID = 8903348671727658184L;
    private JFormattedTextField wsPortField;
    private JFormattedTextField dbPortField;
    private JPasswordField dbPassword;
    private JPasswordField dbPasswordConfirm;
    private JLabel dbPasswordLabel;
    private JLabel dbPasswordConfirmLabel;
    private JTextArea dataDirField;
    private JButton showDataDirButton;
    private JComboBox<String> cmbTheme;
    private JComboBox<String> cmbLanguage;

    public SettingsPanel() {
        JLabel wsPortLabel = new JLabel(LBL_WEB_PORT_TITLE);
        this.wsPortField = new JFormattedTextField();
        this.wsPortField.setColumns(10);
        JLabel dbPortLabel = new JLabel(LBL_DB_PORT_TITLE);
        this.dbPortField = new JFormattedTextField();
        this.dbPortField.setColumns(10);
        try {
            MaskFormatter formatter = new MaskFormatter("####");
            formatter.setAllowsInvalid(true);
            formatter.setOverwriteMode(false);
            this.wsPortField.setFormatterFactory(new DefaultFormatterFactory(formatter));
            this.dbPortField.setFormatterFactory(new DefaultFormatterFactory(formatter));
        }
        catch (ParseException formatter) {
            // empty catch block
        }
        this.dbPasswordLabel = new JLabel(LBL_DB_PASSWORD_TITLE);
        this.dbPasswordConfirmLabel = new JLabel(LBL_DB_PASSWORD_CONFIRM_TITLE);
        this.dbPassword = new JPasswordField();
        this.dbPassword.setColumns(10);
        this.dbPasswordConfirm = new JPasswordField();
        this.dbPasswordConfirm.setColumns(10);
        this.setAllowPasswordChange(false);
        JLabel dataDirLabel = new JLabel(LBL_DATA_DIR_TITLE);
        this.dataDirField = new JTextArea();
        this.dataDirField.setColumns(10);
        this.dataDirField.setRows(4);
        this.dataDirField.setEditable(false);
        this.dataDirField.setLineWrap(true);
        this.dataDirField.setOpaque(false);
        this.dataDirField.setBackground(new Color(0, 0, 0, 0));
        JScrollPane dataDirScroll = new JScrollPane(this.dataDirField);
        dataDirScroll.setVerticalScrollBarPolicy(21);
        dataDirScroll.setHorizontalScrollBarPolicy(31);
        this.showDataDirButton = new JButton(BTN_SHOW_TITLE);
        JLabel themeLabel = new JLabel(LBL_THEME_TITLE);
        JLabel languageLabel = new JLabel(LBL_LANGUAGE_TITLE);
        this.cmbTheme = new JComboBox();
        this.cmbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{LBL_THEME_DEFAULT, LBL_THEME_MODERN}));
        this.cmbLanguage = new JComboBox();
        this.cmbLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{LBL_LANGUAGE_ENGLISH, LBL_LANGUAGE_FRENCH}));
        GroupLayout groupLayout = new GroupLayout(this);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(wsPortLabel).addComponent(dbPortLabel).addComponent(this.dbPasswordLabel).addComponent(this.dbPasswordConfirmLabel).addComponent(languageLabel).addComponent(themeLabel).addComponent(dataDirLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.wsPortField, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.dbPortField, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.dbPassword, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.dbPasswordConfirm, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.cmbLanguage, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(this.cmbTheme, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE).addComponent(dataDirScroll, GroupLayout.Alignment.LEADING, -2, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showDataDirButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(wsPortLabel).addComponent(this.wsPortField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(dbPortLabel).addComponent(this.dbPortField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbPasswordLabel).addComponent(this.dbPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbPasswordConfirmLabel).addComponent(this.dbPasswordConfirm, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(languageLabel).addComponent(this.cmbLanguage, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(themeLabel).addComponent(this.cmbTheme, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(dataDirLabel).addComponent(dataDirScroll, -2, -1, -2).addComponent(this.showDataDirButton)).addContainerGap()));
        this.setLayout(groupLayout);
    }

    public int getWebPort() {
        return (Integer)this.wsPortField.getValue();
    }

    public void setWebPort(int port) {
        this.wsPortField.setValue(port);
    }

    public int getDatabasePort() {
        return (Integer)this.dbPortField.getValue();
    }

    public void setDatabasePort(int port) {
        if (port <= 999 || port >= 9999) {
            throw new IllegalArgumentException(MESSAGE_INVALID_PORT);
        }
        this.dbPortField.setValue(port);
    }

    public void setDatabasePassword(String password) {
        this.dbPassword.setText(password);
        this.dbPasswordConfirm.setText(password);
    }

    public String getDatabasePassword() {
        char[] chars = this.dbPassword.getPassword();
        return chars == null ? null : new String(chars);
    }

    public String getDatabasePasswordConfirm() {
        char[] chars = this.dbPasswordConfirm.getPassword();
        return chars == null ? null : new String(chars);
    }

    public String getLanguage() {
        if (this.cmbLanguage.getSelectedIndex() == 0) {
            return "en";
        }
        if (this.cmbLanguage.getSelectedIndex() == 1) {
            return "fr";
        }
        return null;
    }

    public void setLanguage(String language) {
        int index = -1;
        if ("en".equalsIgnoreCase(language)) {
            index = 0;
        }
        if ("fr".equalsIgnoreCase(language)) {
            index = 1;
        }
        this.cmbLanguage.setSelectedIndex(index);
    }

    public String getTheme() {
        if (this.cmbTheme.getSelectedIndex() == 0) {
            return "";
        }
        if (this.cmbTheme.getSelectedIndex() == 1) {
            return "modern";
        }
        return null;
    }

    public void setTheme(String theme) {
        int index = 0;
        if ("modern".equalsIgnoreCase(theme)) {
            index = 1;
        }
        this.cmbTheme.setSelectedIndex(index);
    }

    public void setAllowPasswordChange(boolean allow) {
        this.dbPassword.setVisible(allow);
        this.dbPasswordLabel.setVisible(allow);
        this.dbPasswordConfirm.setVisible(allow);
        this.dbPasswordConfirmLabel.setVisible(allow);
    }

    public void setDataDirectory(String dir) {
        this.dataDirField.setText(dir);
    }

    public String getDataDirectory() {
        return this.dataDirField.getText();
    }

    public void addDataDirHandler(ActionListener listener) {
        this.showDataDirButton.addActionListener(listener);
    }
}

