/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.gui;

import com.bulenkov.iconloader.IconLoader;
import dorkbox.util.OS;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public final class SwingUtils {
    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(OS.isLinux() ? NimbusLookAndFeel.class.getName() : UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image getImage(String resource) {
        Icon icon = IconLoader.findIcon(resource);
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        icon.paintIcon(null, ((Image)image).getGraphics(), 0, 0);
        return image;
    }

    public static Icon getIcon(String resource) {
        return IconLoader.findIcon(resource);
    }

    public static final <T extends JComponent> T makePlain(T component, float relativeSize) {
        component.setFont(component.getFont().deriveFont(component.getFont().getStyle() & 0xFFFFFFFE, (float)component.getFont().getSize() + relativeSize));
        return component;
    }

    public static final <T extends JComponent> T makeItalic(T component, float relativeSize) {
        component.setFont(component.getFont().deriveFont(component.getFont().getStyle() | 2, (float)component.getFont().getSize() + relativeSize));
        return component;
    }

    public static final <T extends JComponent> T makeBold(T component, float relativeSize) {
        component.setFont(component.getFont().deriveFont(component.getFont().getStyle() | 1, (float)component.getFont().getSize() + relativeSize));
        return component;
    }
}

