/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.launcher.gui;

import com.axelor.launcher.Settings;
import com.axelor.launcher.command.AbstractService;
import com.axelor.launcher.command.CommandContext;
import com.axelor.launcher.command.CompositeService;
import com.axelor.launcher.command.ServiceStatus;
import com.axelor.launcher.gui.Launcher;
import com.axelor.launcher.gui.SwingUtils;
import com.axelor.launcher.i18n.Names;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.gnomeShell.Extension;
import dorkbox.systemTray.jna.linux.AppIndicator;
import dorkbox.util.OSUtil;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;

public final class Tray
extends WindowAdapter
implements Names {
    private static Tray instance;
    private final SystemTray tray;
    private final Settings settings;
    private final AbstractService service;
    private final Launcher launcher;
    private final MenuItem startMenu;
    private final MenuItem stopMenu;
    private final MenuItem exitMenu;
    private final MenuItem aboutMenu;
    private final Thread shutdownHook;

    private Tray() {
        this.settings = CommandContext.getInstance().settings;
        this.service = new CompositeService();
        this.launcher = new Launcher(this.settings, this.service);
        this.launcher.setDefaultCloseOperation(0);
        this.launcher.addWindowListener(this);
        this.tray = SystemTray.get();
        this.tray.setImage(SwingUtils.getImage("/images/icon.png"));
        this.tray.setTooltip(this.settings.getAppName());
        Menu menu = this.tray.getMenu();
        this.aboutMenu = new MenuItem(MENU_AXELOR_TITLE, this::onAbout);
        this.startMenu = new MenuItem(MENU_START_TITLE, this::onStart);
        this.stopMenu = new MenuItem(MENU_STOP_TITLE, this::onStop);
        this.exitMenu = new MenuItem(MENU_EXIT_TITLE, this::onExit);
        menu.add(this.aboutMenu);
        menu.add(new Separator());
        menu.add(this.startMenu);
        menu.add(this.stopMenu);
        menu.add(new Separator());
        menu.add(this.exitMenu);
        this.service.changed(status -> {
            this.startMenu.setEnabled(this.service.canStart());
            this.stopMenu.setEnabled(this.service.canStop());
        });
        this.shutdownHook = new Thread(this.service::stop);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private static SystemTray.TrayType useTrayType() {
        List<String> extensions;
        if (OSUtil.DesktopEnv.isGnome() && ((extensions = Extension.getEnabledExtensions()).contains("ubuntu-appindicators@ubuntu.com") || extensions.contains("appindicatorsupport@rgcjonas.gmail.com")) && AppIndicator.isLoaded) {
            return SystemTray.TrayType.AppIndicator;
        }
        return SystemTray.TrayType.AutoDetect;
    }

    public static void start() {
        if (instance == null) {
            instance = new Tray();
        }
        Tray.instance.launcher.setVisible(true);
        if (Tray.instance.service.isInitialized()) {
            Tray.instance.launcher.showStatus();
        } else {
            Tray.instance.launcher.showSettings();
        }
    }

    private void onAbout(ActionEvent e) {
        this.launcher.setVisible(true);
        this.launcher.toFront();
    }

    private void onStart(ActionEvent e) {
        this.service.start();
    }

    private void onStop(ActionEvent e) {
        this.service.stop();
    }

    private void onExit(ActionEvent e) {
        this.exit();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.exit();
    }

    private void exit() {
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        this.service.stop();
        this.service.changed(status -> {
            if (status == ServiceStatus.STOPPED) {
                this.launcher.dispose();
                this.tray.shutdown();
                System.exit(0);
            }
        });
    }

    static {
        SystemTray.DEFAULT_TRAY_SIZE = 24;
        SystemTray.FORCE_TRAY_TYPE = Tray.useTrayType();
    }
}

