/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.gnomeShell.Extension;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.OSUtil;
import java.awt.Image;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class Tray
extends Menu {
    public static volatile boolean usingGnome = false;
    private volatile String statusText;

    protected static void installExtension() {
        if (usingGnome) {
            if (OSUtil.Linux.isArch()) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Running Arch Linux.");
                }
                if (!Extension.isInstalled()) {
                    SystemTray.logger.info("You may need a work-around for showing the SystemTray icon - we suggest installing the the [Top Icons] plugin (https://extensions.gnome.org/extension/1031/topicons/) which moves icons from the *notification drawer* (it is normally collapsed) at the bottom left corner of the screen to the menu panel next to the clock.");
                }
            } else {
                Extension.install();
            }
        }
    }

    public String getStatus() {
        return this.statusText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String statusText) {
        this.statusText = statusText;
        Entry menuEntry = null;
        List list = this.menuEntries;
        synchronized (list) {
            if (!this.menuEntries.isEmpty()) {
                menuEntry = (Entry)this.menuEntries.get(0);
            }
        }
        if (menuEntry instanceof Status) {
            if (statusText == null) {
                this.remove(menuEntry);
            } else {
                ((Status)menuEntry).setText(statusText);
            }
        } else {
            Status status = new Status();
            status.setText(statusText);
            this.add(status, 0);
        }
    }

    protected void setTooltip_(String tooltipText) {
    }

    final void setTooltip(String tooltipText) {
        if (tooltipText.length() > 64) {
            throw new RuntimeException("Tooltip text cannot be longer than 64 characters.");
        }
        this.setTooltip_(tooltipText);
    }

    @Override
    public void setImage(File imageFile) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, imageFile));
    }

    @Override
    public void setImage(String imagePath) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, imagePath));
    }

    @Override
    public void setImage(URL imageUrl) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, imageUrl));
    }

    @Override
    public void setImage(InputStream imageStream) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, imageStream));
    }

    @Override
    public void setImage(Image image) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, image));
    }

    @Override
    public void setImage(ImageInputStream imageStream) {
        this.setImage_(ImageUtils.resizeAndCache(ImageUtils.TRAY_SIZE, imageStream));
    }
}

