/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.nativeUI.GtkBaseMenuItem;
import dorkbox.systemTray.nativeUI.GtkMenuItem;
import dorkbox.systemTray.nativeUI.GtkMenuItemCheckbox;
import dorkbox.systemTray.nativeUI.GtkMenuItemSeparator;
import dorkbox.systemTray.nativeUI.GtkMenuItemStatus;
import dorkbox.systemTray.peer.MenuPeer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class GtkMenu
extends GtkBaseMenuItem
implements MenuPeer {
    private final List<GtkBaseMenuItem> menuEntries = new LinkedList<GtkBaseMenuItem>();
    private final GtkMenu parent;
    volatile Pointer _nativeMenu;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private AtomicBoolean obliterateInProgress = new AtomicBoolean(false);

    GtkMenu() {
        super(null);
        this.parent = null;
    }

    GtkMenu(GtkMenu parent) {
        super(Gtk.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
    }

    GtkMenu getParent() {
        return this.parent;
    }

    private void add(GtkBaseMenuItem item, int index) {
        if (index > 0) {
            this.menuEntries.add(index, item);
        } else {
            this.menuEntries.add(item);
        }
    }

    protected void onMenuAdded(Pointer menu) {
    }

    private void deleteMenu() {
        if (this.obliterateInProgress.get()) {
            return;
        }
        if (this._nativeMenu != null) {
            int menuEntriesSize = this.menuEntries.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = this.menuEntries.get(i);
                menuEntry__.onDeleteMenu(this._nativeMenu);
            }
            Gtk.gtk_widget_destroy(this._nativeMenu);
        }
        if (this.parent != null) {
            this.parent.deleteMenu();
        }
        this._nativeMenu = Gtk.gtk_menu_new();
        if (this.parent != null) {
            Gtk.gtk_menu_item_set_submenu(this._native, this._nativeMenu);
        }
    }

    private void createMenu() {
        GtkBaseMenuItem menuEntry__;
        int i;
        if (this.obliterateInProgress.get()) {
            return;
        }
        if (this.parent != null) {
            this.parent.createMenu();
        }
        boolean hasImages = false;
        int menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            menuEntry__ = this.menuEntries.get(i);
            hasImages |= menuEntry__.hasImage();
        }
        menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            GtkMenu subMenu;
            menuEntry__ = this.menuEntries.get(i);
            menuEntry__.onCreateMenu(this._nativeMenu, hasImages);
            if (!(menuEntry__ instanceof GtkMenu) || (subMenu = (GtkMenu)menuEntry__).getParent() == this) continue;
            subMenu.createMenu();
        }
        Gtk.gtk_widget_show_all(this._nativeMenu);
        this.onMenuAdded(this._nativeMenu);
    }

    private void obliterateMenu() {
        if (this._nativeMenu != null && !this.obliterateInProgress.get()) {
            this.obliterateInProgress.set(true);
            ArrayList<GtkBaseMenuItem> menuEntriesCopy = new ArrayList<GtkBaseMenuItem>(this.menuEntries);
            this.menuEntries.clear();
            int menuEntriesSize = menuEntriesCopy.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = menuEntriesCopy.get(i);
                menuEntry__.remove();
            }
            menuEntriesCopy.clear();
            Gtk.gtk_widget_destroy(this._nativeMenu);
            this._nativeMenu = null;
            this.obliterateInProgress.set(false);
        }
    }

    @Override
    public void add(final Menu parentMenu, final Entry entry, final int index) {
        Gtk.dispatchAndWait(new Runnable(){

            @Override
            public void run() {
                GtkMenu.this.deleteMenu();
                if (entry instanceof Menu) {
                    GtkMenu item = new GtkMenu(GtkMenu.this);
                    GtkMenu.this.add(item, index);
                    ((Menu)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Separator) {
                    GtkMenuItemSeparator item = new GtkMenuItemSeparator(GtkMenu.this);
                    GtkMenu.this.add(item, index);
                    entry.bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Checkbox) {
                    GtkMenuItemCheckbox item = new GtkMenuItemCheckbox(GtkMenu.this, false);
                    GtkMenu.this.add(item, index);
                    ((Checkbox)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof Status) {
                    GtkMenuItemStatus item = new GtkMenuItemStatus(GtkMenu.this);
                    GtkMenu.this.add(item, index);
                    ((Status)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                } else if (entry instanceof MenuItem) {
                    GtkMenuItem item = new GtkMenuItem(GtkMenu.this);
                    GtkMenu.this.add(item, index);
                    ((MenuItem)entry).bind(item, parentMenu, parentMenu.getSystemTray());
                }
                GtkMenu.this.createMenu();
            }
        });
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        this.setLegitImage(menuItem.getImage() != null);
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkMenu.this.image != null) {
                    Gtk.gtk_container_remove(GtkMenu.this._native, GtkMenu.this.image);
                    GtkMenu.this.image = null;
                    Gtk.gtk_widget_show_all(GtkMenu.this._native);
                }
                if (menuItem.getImage() != null) {
                    GtkMenu.this.image = Gtk.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                    Gtk.gtk_image_menu_item_set_image(GtkMenu.this._native, GtkMenu.this.image);
                    Gtk.gtk_image_menu_item_set_always_show_image(GtkMenu.this._native, true);
                }
                Gtk.gtk_widget_show_all(GtkMenu.this._native);
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_widget_set_sensitive(GtkMenu.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_menu_item_set_label(GtkMenu.this._native, textWithMnemonic);
                Gtk.gtk_widget_show_all(GtkMenu.this._native);
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        this.mnemonicKey = Character.toLowerCase(menuItem.getShortcut());
        this.setText(menuItem);
    }

    public void remove(GtkBaseMenuItem item) {
        this.menuEntries.remove(item);
        this.deleteMenu();
        this.createMenu();
    }

    @Override
    public void remove() {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                GtkMenu parent = GtkMenu.this.getParent();
                if (parent != null) {
                    parent.menuEntries.remove(GtkMenu.this);
                }
                GtkMenu.this.obliterateMenu();
                if (parent != null) {
                    Gtk.gtk_menu_item_set_submenu(GtkMenu.this._native, null);
                    parent.deleteMenu();
                    parent.createMenu();
                }
            }
        });
    }
}

