/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.jna.linux.GCallback;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.nativeUI.GtkBaseMenuItem;
import dorkbox.systemTray.nativeUI.GtkMenu;
import dorkbox.systemTray.peer.MenuItemPeer;
import java.awt.event.ActionListener;

class GtkMenuItem
extends GtkBaseMenuItem
implements MenuItemPeer,
GCallback {
    private final GtkMenu parent;
    private volatile MenuItem menuItemForActionCallback;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';

    GtkMenuItem(GtkMenu parent) {
        super(Gtk.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
        Gobject.g_signal_connect_object(this._native, "activate", this, null, 0);
    }

    @Override
    public int callback(Pointer instance, Pointer data) {
        ActionListener cb;
        if (this.menuItemForActionCallback != null && (cb = this.menuItemForActionCallback.getCallback()) != null) {
            try {
                Gtk.proxyClick(this.menuItemForActionCallback, cb);
            }
            catch (Exception e) {
                SystemTray.logger.error("Error calling menu entry {} click event.", (Object)this.menuItemForActionCallback.getText(), (Object)e);
            }
        }
        return 1;
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        this.setLegitImage(menuItem.getImage() != null);
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                if (GtkMenuItem.this.image != null) {
                    Gtk.gtk_container_remove(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    GtkMenuItem.this.image = null;
                    Gtk.gtk_widget_show_all(GtkMenuItem.this._native);
                }
                if (menuItem.getImage() != null) {
                    GtkMenuItem.this.image = Gtk.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                    Gtk.gtk_image_menu_item_set_image(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    Gtk.gtk_image_menu_item_set_always_show_image(GtkMenuItem.this._native, true);
                }
                Gtk.gtk_widget_show_all(GtkMenuItem.this._native);
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_widget_set_sensitive(GtkMenuItem.this._native, menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        final String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_menu_item_set_label(GtkMenuItem.this._native, textWithMnemonic);
                Gtk.gtk_widget_show_all(GtkMenuItem.this._native);
            }
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
        this.menuItemForActionCallback = menuItem;
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        this.mnemonicKey = Character.toLowerCase(menuItem.getShortcut());
        this.setText(menuItem);
    }

    @Override
    public void remove() {
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                Gtk.gtk_container_remove(((GtkMenuItem)GtkMenuItem.this).parent._nativeMenu, GtkMenuItem.this._native);
                GtkMenuItem.super.remove();
                GtkMenuItem.this.menuItemForActionCallback = null;
                if (GtkMenuItem.this.image != null) {
                    Gtk.gtk_container_remove(GtkMenuItem.this._native, GtkMenuItem.this.image);
                    GtkMenuItem.this.image = null;
                }
                GtkMenuItem.this.parent.remove(GtkMenuItem.this);
            }
        });
    }
}

