/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import com.sun.jna.Pointer;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.jna.linux.AppIndicator;
import dorkbox.systemTray.jna.linux.AppIndicatorInstanceStruct;
import dorkbox.systemTray.jna.linux.Gobject;
import dorkbox.systemTray.jna.linux.Gtk;
import dorkbox.systemTray.nativeUI.GtkMenu;
import dorkbox.systemTray.nativeUI.NativeUI;
import dorkbox.systemTray.util.ImageUtils;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;

public class _AppIndicatorNativeTray
extends Tray
implements NativeUI {
    private volatile AppIndicatorInstanceStruct appIndicator;
    private boolean isActive = false;
    private AtomicBoolean shuttingDown = new AtomicBoolean();
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile boolean setName = false;

    public _AppIndicatorNativeTray(SystemTray systemTray) {
        Gtk.startGui();
        GtkMenu gtkMenu = new GtkMenu(){

            @Override
            protected final void onMenuAdded(Pointer menu) {
                AppIndicator.app_indicator_set_menu(_AppIndicatorNativeTray.this.appIndicator, menu);
                if (!_AppIndicatorNativeTray.this.setName) {
                    _AppIndicatorNativeTray.this.setName = true;
                    AppIndicator.app_indicator_set_title(_AppIndicatorNativeTray.this.appIndicator, "SystemTray");
                }
            }

            @Override
            public void setEnabled(final MenuItem menuItem) {
                Gtk.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        boolean enabled = menuItem.getEnabled();
                        if (_AppIndicatorNativeTray.this.visible && !enabled) {
                            AppIndicator.app_indicator_set_status(_AppIndicatorNativeTray.this.appIndicator, 0);
                            _AppIndicatorNativeTray.this.visible = false;
                        } else if (!_AppIndicatorNativeTray.this.visible && enabled) {
                            AppIndicator.app_indicator_set_status(_AppIndicatorNativeTray.this.appIndicator, 1);
                            _AppIndicatorNativeTray.this.visible = true;
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AppIndicatorNativeTray.this.imageFile = menuItem.getImage();
                if (_AppIndicatorNativeTray.this.imageFile == null) {
                    return;
                }
                Gtk.dispatch(new Runnable(){

                    @Override
                    public void run() {
                        AppIndicator.app_indicator_set_icon(_AppIndicatorNativeTray.this.appIndicator, _AppIndicatorNativeTray.this.imageFile.getAbsolutePath());
                        if (!_AppIndicatorNativeTray.this.isActive) {
                            _AppIndicatorNativeTray.this.isActive = true;
                            AppIndicator.app_indicator_set_status(_AppIndicatorNativeTray.this.appIndicator, 1);
                        }
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void remove() {
                if (!_AppIndicatorNativeTray.this.shuttingDown.getAndSet(true)) {
                    final AppIndicatorInstanceStruct savedAppIndicator = _AppIndicatorNativeTray.this.appIndicator;
                    _AppIndicatorNativeTray.this.appIndicator = null;
                    Gtk.dispatch(new Runnable(){

                        @Override
                        public void run() {
                            AppIndicator.app_indicator_set_status(savedAppIndicator, 0);
                            Pointer p = savedAppIndicator.getPointer();
                            Gobject.g_object_unref(p);
                        }
                    });
                    super.remove();
                    Gtk.shutdownGui();
                }
            }
        };
        Gtk.dispatch(new Runnable(){

            @Override
            public void run() {
                File image = ImageUtils.getTransparentImage(ImageUtils.ENTRY_SIZE);
                String id = System.nanoTime() + "DBST";
                _AppIndicatorNativeTray.this.appIndicator = AppIndicator.app_indicator_new(id, image.getAbsolutePath(), 0);
            }
        });
        Gtk.waitForStartup();
        this.bind(gtkMenu, null, systemTray);
    }

    @Override
    protected void setTooltip_(String tooltipText) {
    }

    @Override
    public final boolean hasImage() {
        return this.imageFile != null;
    }
}

