/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.nativeUI;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.Tray;
import dorkbox.systemTray.nativeUI.AwtMenu;
import dorkbox.systemTray.nativeUI.NativeUI;
import dorkbox.util.OS;
import dorkbox.util.SwingUtil;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.io.File;
import javax.swing.ImageIcon;

public class _AwtTray
extends Tray
implements NativeUI {
    private volatile java.awt.SystemTray tray;
    private volatile TrayIcon trayIcon;
    private volatile boolean visible = true;
    private volatile File imageFile;
    private volatile String tooltipText = null;
    private final Object keepAliveLock = new Object[0];
    private Thread keepAliveThread;

    public _AwtTray(SystemTray systemTray) {
        if (!java.awt.SystemTray.isSupported()) {
            throw new RuntimeException("System Tray is not supported in this configuration! Please write an issue and include your OS type and configuration");
        }
        this.tray = java.awt.SystemTray.getSystemTray();
        AwtMenu awtMenu = new AwtMenu(null){

            @Override
            public void setEnabled(final MenuItem menuItem) {
                SwingUtil.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        boolean enabled = menuItem.getEnabled();
                        if (OS.isMacOsX()) {
                            if (_AwtTray.this.keepAliveThread != null) {
                                Object object = _AwtTray.this.keepAliveLock;
                                synchronized (object) {
                                    _AwtTray.this.keepAliveLock.notifyAll();
                                }
                            }
                            _AwtTray.this.keepAliveThread = null;
                            if (_AwtTray.this.visible && !enabled) {
                                _AwtTray.this.keepAliveThread = new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Object object = _AwtTray.this.keepAliveLock;
                                        synchronized (object) {
                                            _AwtTray.this.keepAliveLock.notifyAll();
                                            try {
                                                _AwtTray.this.keepAliveLock.wait();
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }, "TrayKeepAliveThread");
                                _AwtTray.this.keepAliveThread.start();
                            }
                        }
                        if (_AwtTray.this.visible && !enabled) {
                            _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                            _AwtTray.this.visible = false;
                        } else if (!_AwtTray.this.visible && enabled) {
                            try {
                                _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                                _AwtTray.this.visible = true;
                                _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("Error adding the icon back to the tray", e);
                            }
                        }
                    }
                });
            }

            @Override
            public void setImage(MenuItem menuItem) {
                _AwtTray.this.imageFile = menuItem.getImage();
                if (_AwtTray.this.imageFile == null) {
                    return;
                }
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Image trayImage = new ImageIcon(_AwtTray.this.imageFile.getAbsolutePath()).getImage();
                        trayImage.flush();
                        if (_AwtTray.this.trayIcon == null) {
                            _AwtTray.this.trayIcon = new TrayIcon(trayImage);
                            _AwtTray.this.trayIcon.setPopupMenu((PopupMenu)_native);
                            try {
                                _AwtTray.this.tray.add(_AwtTray.this.trayIcon);
                            }
                            catch (AWTException e) {
                                SystemTray.logger.error("TrayIcon could not be added.", e);
                            }
                        } else {
                            _AwtTray.this.trayIcon.setImage(trayImage);
                        }
                        _AwtTray.this.trayIcon.setToolTip(_AwtTray.this.tooltipText);
                    }
                });
            }

            @Override
            public void setText(MenuItem menuItem) {
            }

            @Override
            public void setShortcut(MenuItem menuItem) {
            }

            @Override
            public void remove() {
                SwingUtil.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (_AwtTray.this.trayIcon != null) {
                            _AwtTray.this.trayIcon.setPopupMenu(null);
                            _AwtTray.this.tray.remove(_AwtTray.this.trayIcon);
                            _AwtTray.this.trayIcon = null;
                        }
                        _AwtTray.this.tray = null;
                    }
                });
                super.remove();
            }
        };
        this.bind(awtMenu, null, systemTray);
    }

    @Override
    protected void setTooltip_(final String tooltipText) {
        this.tooltipText = tooltipText;
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (_AwtTray.this.trayIcon != null) {
                    _AwtTray.this.trayIcon.setToolTip(tooltipText);
                }
            }
        });
    }

    @Override
    public boolean hasImage() {
        return this.imageFile != null;
    }
}

