/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.swingUI;

import dorkbox.systemTray.Entry;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.swingUI.SwingMenu;
import dorkbox.systemTray.util.ImageUtils;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItem
implements MenuItemPeer {
    private static ImageIcon transparentIcon;
    private final SwingMenu parent;
    private final JMenuItem _native = new JMenuItem();
    private volatile ActionListener swingCallback;

    SwingMenuItem(SwingMenu parent, Entry entry) {
        this.parent = parent;
        if (ImageUtils.ENTRY_FONT != null) {
            this._native.setFont(ImageUtils.ENTRY_FONT);
        }
        if (SystemTray.SWING_UI != null) {
            this._native.setUI(SystemTray.SWING_UI.getItemUI(this._native, entry));
        }
        parent._native.add(this._native);
        if (transparentIcon == null) {
            File uncheckedFile = ImageUtils.getTransparentImage(ImageUtils.ENTRY_SIZE);
            transparentIcon = new ImageIcon(uncheckedFile.getAbsolutePath());
        }
        this._native.setIcon(transparentIcon);
    }

    @Override
    public void setImage(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                File imageFile = menuItem.getImage();
                if (imageFile != null) {
                    ImageIcon origIcon = new ImageIcon(imageFile.getAbsolutePath());
                    SwingMenuItem.this._native.setIcon(origIcon);
                } else {
                    SwingMenuItem.this._native.setIcon(transparentIcon);
                }
            }
        });
    }

    @Override
    public void setEnabled(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setEnabled(menuItem.getEnabled());
            }
        });
    }

    @Override
    public void setText(final MenuItem menuItem) {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setText(menuItem.getText());
            }
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.swingCallback != null) {
            this._native.removeActionListener(this.swingCallback);
        }
        if (menuItem.getCallback() != null) {
            this.swingCallback = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionListener cb = menuItem.getCallback();
                    if (cb != null) {
                        try {
                            cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    }
                }
            };
            this._native.addActionListener(this.swingCallback);
        } else {
            this.swingCallback = null;
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        final int vKey = SwingUtil.getVirtualKey(shortcut);
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingMenuItem.this._native.setMnemonic(vKey);
            }
        });
    }

    @Override
    public void remove() {
        SwingUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SwingMenuItem.this.swingCallback != null) {
                    SwingMenuItem.this._native.removeActionListener(SwingMenuItem.this.swingCallback);
                    SwingMenuItem.this.swingCallback = null;
                }
                ((SwingMenuItem)SwingMenuItem.this).parent._native.remove(SwingMenuItem.this._native);
                SwingMenuItem.this._native.removeAll();
            }
        });
    }
}

