/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import com.sun.jna.Pointer;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.jna.windows.Gdi32;
import dorkbox.systemTray.jna.windows.User32;
import dorkbox.util.CacheUtil;
import dorkbox.util.FileUtil;
import dorkbox.util.IO;
import dorkbox.util.LocationResolver;
import dorkbox.util.OS;
import dorkbox.util.OSUtil;
import dorkbox.util.SwingUtil;
import dorkbox.util.process.ShellProcessBuilder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public class ImageUtils {
    private static final File TEMP_DIR = new File(CacheUtil.TEMP_DIR, "ResizedImages");
    public static volatile int TRAY_SIZE = 0;
    public static volatile int ENTRY_SIZE = 0;
    public static volatile Font ENTRY_FONT = null;

    public static void determineIconSize() {
        double trayScalingFactor = 0.0;
        double menuScalingFactor = 0.0;
        if (SystemTray.AUTO_TRAY_SIZE) {
            if (OS.isWindows()) {
                int[] version = OSUtil.Windows.getVersion();
                trayScalingFactor = version[0] <= 5 ? 2.0 : (version[0] == 6 && version[1] == 0 ? 2.0 : (version[0] == 6 && version[1] <= 2 ? 4.0 : 4.0));
                Pointer screen = User32.GetDC(null);
                int dpiX = Gdi32.GetDeviceCaps(screen, 88);
                User32.ReleaseDC(null, screen);
                if (dpiX != 96) {
                    menuScalingFactor = (double)dpiX / 96.0;
                }
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Windows version: '{}'", (Object)Arrays.toString(version));
                    SystemTray.logger.debug("Windows DPI settings: '{}'", (Object)dpiX);
                }
            } else if (OS.isLinux() || OS.isUnix()) {
                double plasmaVersion;
                String XDG = System.getenv("XDG_CURRENT_DESKTOP");
                if (XDG == null && (plasmaVersion = OSUtil.DesktopEnv.getPlasmaVersion()) > 0.0) {
                    XDG = "kde";
                }
                if ("kde".equalsIgnoreCase(XDG)) {
                    plasmaVersion = OSUtil.DesktopEnv.getPlasmaVersion();
                    if (plasmaVersion > 0.0) {
                        trayScalingFactor = 2.0;
                    } else if (SystemTray.DEBUG) {
                        SystemTray.logger.error("Cannot check plasmashell version");
                    }
                } else {
                    block29: {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8196);
                            PrintStream outputStream = new PrintStream(byteArrayOutputStream);
                            ShellProcessBuilder shellVersion = new ShellProcessBuilder(outputStream);
                            shellVersion.setExecutable("gsettings");
                            shellVersion.addArgument("get");
                            shellVersion.addArgument("org.gnome.desktop.interface");
                            shellVersion.addArgument("scaling-factor");
                            shellVersion.start();
                            String output = ShellProcessBuilder.getOutput(byteArrayOutputStream);
                            if (!output.isEmpty()) {
                                if (SystemTray.DEBUG) {
                                    SystemTray.logger.debug("Checking scaling factor for GTK environment, should start with 'uint32', value: '{}'", (Object)output);
                                }
                                if (output.contains("uint32")) {
                                    String value = output.substring(output.indexOf("uint") + 7, output.length());
                                    trayScalingFactor = Integer.parseInt(value);
                                    menuScalingFactor = Integer.parseInt(value);
                                }
                            }
                        }
                        catch (Throwable e) {
                            if (!SystemTray.DEBUG) break block29;
                            SystemTray.logger.error("Cannot check scaling factor", e);
                        }
                    }
                    int fedoraVersion = OSUtil.Linux.getFedoraVersion();
                    if (trayScalingFactor == 0.0 && fedoraVersion >= 23) {
                        if (SystemTray.DEBUG) {
                            SystemTray.logger.debug("Adjusting tray/menu scaling for FEDORA " + fedoraVersion);
                        }
                        trayScalingFactor = 2.0;
                    }
                }
            } else if (OS.isMacOsX()) {
                int height;
                if (!SwingUtilities.isEventDispatchThread()) {
                    final AtomicInteger h = new AtomicInteger(0);
                    SwingUtil.invokeAndWaitQuietly(new Runnable(){

                        @Override
                        public void run() {
                            h.set((int)java.awt.SystemTray.getSystemTray().getTrayIconSize().getHeight());
                        }
                    });
                    height = h.get();
                } else {
                    height = (int)java.awt.SystemTray.getSystemTray().getTrayIconSize().getHeight();
                }
                trayScalingFactor = height < 32 ? 2.0 : ((height & height - 1) == 0 ? (double)(height / SystemTray.DEFAULT_TRAY_SIZE) : 8.0);
            }
        }
        TRAY_SIZE = trayScalingFactor > 1.0 ? (int)((double)SystemTray.DEFAULT_TRAY_SIZE * trayScalingFactor) : SystemTray.DEFAULT_TRAY_SIZE;
        ENTRY_SIZE = menuScalingFactor > 1.0 ? (int)((double)SystemTray.DEFAULT_MENU_SIZE * menuScalingFactor) : SystemTray.DEFAULT_MENU_SIZE;
        if (OS.isWindows()) {
            Font font = new JMenuItem().getFont().deriveFont(0);
            if (menuScalingFactor > 1.0) {
                font = ImageUtils.getFontForSpecificHeight(font, ENTRY_SIZE);
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Menu entry font size '{}' found for requested size '{}'", (Object)font.getSize(), (Object)ENTRY_SIZE);
                }
            } else if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Menu entry font size '{}'. Not scaling for requested size '{}'", (Object)font.getSize(), (Object)ENTRY_SIZE);
            }
            ENTRY_FONT = font;
        }
        if (SystemTray.DEBUG) {
            SystemTray.logger.debug("ScalingFactor is '{}', tray icon size is '{}'.", (Object)trayScalingFactor, (Object)TRAY_SIZE);
            SystemTray.logger.debug("ScalingFactor is '{}', tray menu size is '{}'.", (Object)menuScalingFactor, (Object)ENTRY_SIZE);
        }
    }

    private static Font getFontForSpecificHeight(Font font, int height) {
        Font fontCheck;
        int size = font.getSize();
        Boolean lastAction = null;
        BufferedImage image = new BufferedImage(1, 1, 1);
        Graphics2D g = image.createGraphics();
        while (true) {
            FontMetrics metrics;
            Rectangle2D rect;
            int testHeight;
            if ((testHeight = (int)(rect = (metrics = g.getFontMetrics(fontCheck = new Font(font.getName(), 0, size))).getStringBounds("Tj|", g)).getHeight()) < height && lastAction != Boolean.FALSE) {
                ++size;
                lastAction = Boolean.TRUE;
                continue;
            }
            if (testHeight <= height || lastAction == Boolean.TRUE) break;
            --size;
            lastAction = Boolean.FALSE;
        }
        return fontCheck;
    }

    public static File getTransparentImage(int size) {
        File newFile = new File(TEMP_DIR, size + "_empty.png").getAbsoluteFile();
        if (newFile.canRead() && newFile.isFile()) {
            return newFile;
        }
        newFile.getParentFile().mkdirs();
        try {
            BufferedImage image = ImageUtils.getTransparentImageAsBufferedImage(size);
            ImageIO.write((RenderedImage)image, "png", newFile);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error creating transparent image for size: {}", (Object)size, (Object)e);
        }
        return newFile;
    }

    public static BufferedImage getTransparentImageAsBufferedImage(int size) {
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setColor(new Color(0, 0, 0, 0));
        g2d.fillRect(0, 0, size, size);
        g2d.dispose();
        return image;
    }

    private static File getErrorImage(String cacheName) {
        try {
            File save = CacheUtil.save(cacheName, ImageUtils.class.getResource("error_32.png"));
            save.deleteOnExit();
            return save;
        }
        catch (Exception e) {
            throw new RuntimeException("Serious problems! Unable to extract error image, this should NEVER happen!", e);
        }
    }

    private static File getIfCachedOrError(String cacheName) {
        try {
            File check = CacheUtil.check(cacheName);
            if (check != null) {
                return check;
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error checking cache for information. Using error icon instead", e);
            return ImageUtils.getErrorImage(cacheName);
        }
        return null;
    }

    public static synchronized File resizeAndCache(int size, File file) {
        return ImageUtils.resizeAndCache(size, file.getAbsolutePath());
    }

    public static synchronized File resizeAndCache(int size, String fileName) {
        if (fileName == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(fileName);
            File file = ImageUtils.resizeAndCache(size, fileInputStream);
            fileInputStream.close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", e);
            return ImageUtils.getErrorImage(size + "default");
        }
    }

    public static synchronized File resizeAndCache(int size, URL imageUrl) {
        if (imageUrl == null) {
            return null;
        }
        try {
            InputStream inputStream = imageUrl.openStream();
            File file = ImageUtils.resizeAndCache(size, inputStream);
            inputStream.close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", e);
            return ImageUtils.getErrorImage(size + "default");
        }
    }

    public static synchronized File resizeAndCache(int size, Image image) {
        if (image == null) {
            return null;
        }
        Image trayImage = new ImageIcon(image).getImage();
        trayImage.flush();
        try {
            BufferedImage bufferedImage = ImageUtils.getBufferedImage(trayImage);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "png", os);
            ByteArrayInputStream imageInputStream = new ByteArrayInputStream(os.toByteArray());
            File file = ImageUtils.resizeAndCache(size, imageInputStream);
            ((InputStream)imageInputStream).close();
            return file;
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", e);
            return ImageUtils.getErrorImage(size + "default");
        }
    }

    public static synchronized File resizeAndCache(int size, ImageInputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream(imageStream);
            return ImageUtils.resizeAndCache(size, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (Exception e) {
            SystemTray.logger.error("Error reading image. Using error icon instead", e);
            return ImageUtils.getErrorImage(size + "default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File resizeAndCache(int size, InputStream imageStream) {
        if (imageStream == null) {
            return null;
        }
        if (!(imageStream instanceof ByteArrayInputStream)) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = IO.copyStream(imageStream);
                imageStream.close();
                imageStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read from inputStream.", e);
            }
        }
        imageStream.mark(0);
        String cacheName = size + "_" + CacheUtil.createNameAsHash(imageStream);
        ((ByteArrayInputStream)imageStream).reset();
        File check = ImageUtils.getIfCachedOrError(cacheName);
        if (check != null) {
            return check;
        }
        boolean needsResize = true;
        try {
            imageStream.mark(0);
            Dimension imageSize = ImageUtils.getImageSize(imageStream);
            if (size == (int)imageSize.getWidth() && size == (int)imageSize.getHeight()) {
                needsResize = false;
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error resizing image. Using error icon instead", e);
            File file = ImageUtils.getErrorImage(cacheName);
            return file;
        }
        finally {
            ((ByteArrayInputStream)imageStream).reset();
        }
        if (needsResize) {
            try {
                File resizedFile = ImageUtils.resizeFileNoCheck(size, imageStream);
                try {
                    return CacheUtil.save(cacheName, resizedFile);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Error caching image. Using error icon instead", e);
                    return ImageUtils.getErrorImage(cacheName);
                }
            }
            catch (Exception e) {
                SystemTray.logger.error("Error resizing image. Using error icon instead", e);
                return ImageUtils.getErrorImage(cacheName);
            }
        }
        try {
            return CacheUtil.save(cacheName, imageStream);
        }
        catch (Exception e) {
            SystemTray.logger.error("Error caching image. Using error icon instead", e);
            return ImageUtils.getErrorImage(cacheName);
        }
    }

    private static File resizeFileNoCheck(int size, URL imageUrl) throws IOException {
        String extension = FileUtil.getExtension(imageUrl.getPath());
        if (extension.isEmpty()) {
            extension = "png";
        }
        InputStream inputStream = imageUrl.openStream();
        File newFile = new File(TEMP_DIR, "temp_resize." + extension).getAbsoluteFile();
        Image image = new ImageIcon(ImageIO.read(inputStream)).getImage().getScaledInstance(size, -1, 4);
        image.flush();
        image = new ImageIcon(image).getImage();
        image.flush();
        newFile.getParentFile().mkdirs();
        newFile.delete();
        BufferedImage bufferedImage = ImageUtils.getBufferedImage(image);
        ImageIO.write((RenderedImage)bufferedImage, extension, newFile);
        return newFile;
    }

    private static File resizeFileNoCheck(int size, InputStream inputStream) throws IOException {
        File newFile = new File(TEMP_DIR, "temp_resize.png").getAbsoluteFile();
        Image image = new ImageIcon(ImageIO.read(inputStream)).getImage().getScaledInstance(size, -1, 4);
        image.flush();
        image = new ImageIcon(image).getImage();
        image.flush();
        newFile.getParentFile().mkdirs();
        newFile.delete();
        BufferedImage bufferedImage = ImageUtils.getBufferedImage(image);
        ImageIO.write((RenderedImage)bufferedImage, "png", newFile);
        return newFile;
    }

    private static String resizeFile(int size, String fileName) throws IOException {
        Image image;
        FileInputStream fileInputStream = new FileInputStream(fileName);
        Dimension imageSize = ImageUtils.getImageSize(fileInputStream);
        if (size == (int)imageSize.getWidth() && size == (int)imageSize.getHeight()) {
            return fileName;
        }
        String extension = FileUtil.getExtension(fileName);
        if (extension.isEmpty()) {
            extension = "png";
        }
        File newFile = new File(TEMP_DIR, "temp_resize." + extension).getAbsoluteFile();
        File iconTest = new File(fileName);
        if (iconTest.isFile() && iconTest.canRead()) {
            String absolutePath = iconTest.getAbsolutePath();
            image = new ImageIcon(absolutePath).getImage().getScaledInstance(size, -1, 4);
            image.flush();
        } else {
            URL systemResource = LocationResolver.getResource(fileName);
            image = new ImageIcon(systemResource).getImage().getScaledInstance(size, -1, 4);
            image.flush();
        }
        image = new ImageIcon(image).getImage();
        image.flush();
        newFile.getParentFile().mkdirs();
        newFile.delete();
        BufferedImage bufferedImage = ImageUtils.getBufferedImage(image);
        ImageIO.write((RenderedImage)bufferedImage, extension, newFile);
        return newFile.getAbsolutePath();
    }

    private static BufferedImage getBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Dimension getImageSize(InputStream fileStream) throws IOException {
        ImageInputStream in = null;
        ImageReader reader = null;
        try {
            in = ImageIO.createImageInputStream(fileStream);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
            if (readers.hasNext()) {
                reader = readers.next();
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                reader.dispose();
            }
        }
        throw new IOException("Unable to read file inputStream for image size data.");
    }
}

