/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AnalyticAxis;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ANALYTIC_ACCOUNT", uniqueConstraints={@UniqueConstraint(columnNames={"code", "name", "analytic_axis"})}, indexes={@Index(columnList="code"), @Index(columnList="name"), @Index(columnList="analytic_axis"), @Index(columnList="parent")})
public class AnalyticAccount
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ANALYTIC_ACCOUNT_SEQ")
    @SequenceGenerator(name="ACCOUNT_ANALYTIC_ACCOUNT_SEQ", sequenceName="ACCOUNT_ANALYTIC_ACCOUNT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Code")
    @NotNull
    private String code;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Analytic axis")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAxis analyticAxis;
    @Widget(title="Parent Analytic Acc.")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount parent;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public AnalyticAccount() {
    }

    public AnalyticAccount(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AnalyticAxis getAnalyticAxis() {
        return this.analyticAxis;
    }

    public void setAnalyticAxis(AnalyticAxis analyticAxis) {
        this.analyticAxis = analyticAxis;
    }

    public AnalyticAccount getParent() {
        return this.parent;
    }

    public void setParent(AnalyticAccount parent) {
        this.parent = parent;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalyticAccount)) {
            return false;
        }
        AnalyticAccount other = (AnalyticAccount)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("code", (Object)this.getCode()).add("name", (Object)this.getName()).omitNullValues().toString();
    }
}

