/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_CHEQUE_REJECTION", uniqueConstraints={@UniqueConstraint(columnNames={"name", "company"})}, indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="partner"), @Index(columnList="payment_voucher"), @Index(columnList="interbank_code_line"), @Index(columnList="move"), @Index(columnList="payment_mode")})
public class ChequeRejection
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_CHEQUE_REJECTION_SEQ")
    @SequenceGenerator(name="ACCOUNT_CHEQUE_REJECTION_SEQ", sequenceName="ACCOUNT_CHEQUE_REJECTION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Reference", readonly=true)
    private String name;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Date", readonly=true)
    private ZonedDateTime dateTime;
    @Widget(title="Customer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Payment voucher")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentVoucher paymentVoucher;
    @Widget(title="Rejected amount", readonly=true)
    private BigDecimal amountRejected = BigDecimal.ZERO;
    @Widget(title="Rejection date")
    @NotNull
    private LocalDate rejectionDate;
    @Widget(title="Rejection reason")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine interbankCodeLine;
    @Widget(title="Status", readonly=true, selection="iaccount.cheque.rejection.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Rejection move")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Move move;
    @Widget(title="Payment Mode", hidden=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PaymentMode paymentMode;
    @Widget(title="Description")
    private String description = "Cheque rejection";
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ChequeRejection() {
    }

    public ChequeRejection(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(ZonedDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public PaymentVoucher getPaymentVoucher() {
        return this.paymentVoucher;
    }

    public void setPaymentVoucher(PaymentVoucher paymentVoucher) {
        this.paymentVoucher = paymentVoucher;
    }

    public BigDecimal getAmountRejected() {
        return this.amountRejected == null ? BigDecimal.ZERO : this.amountRejected;
    }

    public void setAmountRejected(BigDecimal amountRejected) {
        this.amountRejected = amountRejected;
    }

    public LocalDate getRejectionDate() {
        return this.rejectionDate;
    }

    public void setRejectionDate(LocalDate rejectionDate) {
        this.rejectionDate = rejectionDate;
    }

    public InterbankCodeLine getInterbankCodeLine() {
        return this.interbankCodeLine;
    }

    public void setInterbankCodeLine(InterbankCodeLine interbankCodeLine) {
        this.interbankCodeLine = interbankCodeLine;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Move getMove() {
        return this.move;
    }

    public void setMove(Move move) {
        this.move = move;
    }

    public PaymentMode getPaymentMode() {
        return this.paymentMode;
    }

    public void setPaymentMode(PaymentMode paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChequeRejection)) {
            return false;
        }
        ChequeRejection other = (ChequeRejection)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("dateTime", (Object)this.getDateTime()).add("amountRejected", (Object)this.getAmountRejected()).add("rejectionDate", (Object)this.getRejectionDate()).add("statusSelect", (Object)this.getStatusSelect()).add("description", (Object)this.getDescription()).omitNullValues().toString();
    }
}

