/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.base.db.PartnerCategory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_DEBT_RECOVERY_CONFIG_LINE", indexes={@Index(columnList="partner_category"), @Index(columnList="debt_recovery_method"), @Index(columnList="account_config")})
public class DebtRecoveryConfigLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEBT_RECOVERY_CONFIG_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEBT_RECOVERY_CONFIG_LINE_SEQ", sequenceName="ACCOUNT_DEBT_RECOVERY_CONFIG_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Partner category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private PartnerCategory partnerCategory;
    @Widget(title="Debt recovery method")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethod debtRecoveryMethod;
    @Widget(title="Account configuration")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountConfig accountConfig;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PartnerCategory getPartnerCategory() {
        return this.partnerCategory;
    }

    public void setPartnerCategory(PartnerCategory partnerCategory) {
        this.partnerCategory = partnerCategory;
    }

    public DebtRecoveryMethod getDebtRecoveryMethod() {
        return this.debtRecoveryMethod;
    }

    public void setDebtRecoveryMethod(DebtRecoveryMethod debtRecoveryMethod) {
        this.debtRecoveryMethod = debtRecoveryMethod;
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public void setAccountConfig(AccountConfig accountConfig) {
        this.accountConfig = accountConfig;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebtRecoveryConfigLine)) {
            return false;
        }
        DebtRecoveryConfigLine other = (DebtRecoveryConfigLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).omitNullValues().toString();
    }
}

