/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.VirtualColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@DynamicInsert
@DynamicUpdate
@Table(name="ACCOUNT_DEBT_RECOVERY_HISTORY", indexes={@Index(columnList="debt_recovery"), @Index(columnList="debt_recovery_method"), @Index(columnList="debt_recovery_method_line"), @Index(columnList="user_debt_recovery"), @Index(columnList="name")})
public class DebtRecoveryHistory
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEBT_RECOVERY_HISTORY_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEBT_RECOVERY_HISTORY_SEQ", sequenceName="ACCOUNT_DEBT_RECOVERY_HISTORY_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Debt recovery")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecovery debtRecovery;
    @Widget(title="Debt recovery method")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethod debtRecoveryMethod;
    @Widget(title="DebtRecoveryHistory.debtRecoveryMethodLine")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethodLine debtRecoveryMethodLine;
    @Widget(title="Last debt recovery date")
    private LocalDate debtRecoveryDate;
    @Widget(title="Reference date")
    private LocalDate referenceDate;
    @Widget(title="Shift to irrecoverable")
    private Boolean setToIrrecoverableOK = Boolean.FALSE;
    @Widget(title="Address unknown")
    private Boolean unknownAddressOK = Boolean.FALSE;
    @Widget(title="Partner Balance due")
    private BigDecimal balanceDue = BigDecimal.ZERO;
    @Widget(title="Balance due recoverable")
    private BigDecimal balanceDueDebtRecovery = BigDecimal.ZERO;
    @Widget(title="User")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User userDebtRecovery;
    @Widget(title="Name", search={"referenceDate", "debtRecovery"})
    @NameColumn
    @VirtualColumn
    @Access(value=AccessType.PROPERTY)
    private String name;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DebtRecoveryHistory() {
    }

    public DebtRecoveryHistory(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DebtRecovery getDebtRecovery() {
        return this.debtRecovery;
    }

    public void setDebtRecovery(DebtRecovery debtRecovery) {
        this.debtRecovery = debtRecovery;
    }

    public DebtRecoveryMethod getDebtRecoveryMethod() {
        return this.debtRecoveryMethod;
    }

    public void setDebtRecoveryMethod(DebtRecoveryMethod debtRecoveryMethod) {
        this.debtRecoveryMethod = debtRecoveryMethod;
    }

    public DebtRecoveryMethodLine getDebtRecoveryMethodLine() {
        return this.debtRecoveryMethodLine;
    }

    public void setDebtRecoveryMethodLine(DebtRecoveryMethodLine debtRecoveryMethodLine) {
        this.debtRecoveryMethodLine = debtRecoveryMethodLine;
    }

    public LocalDate getDebtRecoveryDate() {
        return this.debtRecoveryDate;
    }

    public void setDebtRecoveryDate(LocalDate debtRecoveryDate) {
        this.debtRecoveryDate = debtRecoveryDate;
    }

    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public Boolean getSetToIrrecoverableOK() {
        return this.setToIrrecoverableOK == null ? Boolean.FALSE : this.setToIrrecoverableOK;
    }

    public void setSetToIrrecoverableOK(Boolean setToIrrecoverableOK) {
        this.setToIrrecoverableOK = setToIrrecoverableOK;
    }

    public Boolean getUnknownAddressOK() {
        return this.unknownAddressOK == null ? Boolean.FALSE : this.unknownAddressOK;
    }

    public void setUnknownAddressOK(Boolean unknownAddressOK) {
        this.unknownAddressOK = unknownAddressOK;
    }

    public BigDecimal getBalanceDue() {
        return this.balanceDue == null ? BigDecimal.ZERO : this.balanceDue;
    }

    public void setBalanceDue(BigDecimal balanceDue) {
        this.balanceDue = balanceDue;
    }

    public BigDecimal getBalanceDueDebtRecovery() {
        return this.balanceDueDebtRecovery == null ? BigDecimal.ZERO : this.balanceDueDebtRecovery;
    }

    public void setBalanceDueDebtRecovery(BigDecimal balanceDueDebtRecovery) {
        this.balanceDueDebtRecovery = balanceDueDebtRecovery;
    }

    public User getUserDebtRecovery() {
        return this.userDebtRecovery;
    }

    public void setUserDebtRecovery(User userDebtRecovery) {
        this.userDebtRecovery = userDebtRecovery;
    }

    public String getName() {
        try {
            this.name = this.computeName();
        }
        catch (NullPointerException e) {
            Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
            logger.error("NPE in function field: getName()", (Throwable)e);
        }
        return this.name;
    }

    protected String computeName() {
        String name = " - ";
        if (this.referenceDate != null) {
            name = this.referenceDate.toString();
        }
        if (this.debtRecovery != null) {
            name = this.debtRecovery.getName() + " : " + name;
        }
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebtRecoveryHistory)) {
            return false;
        }
        DebtRecoveryHistory other = (DebtRecoveryHistory)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("debtRecoveryDate", (Object)this.getDebtRecoveryDate()).add("referenceDate", (Object)this.getReferenceDate()).add("setToIrrecoverableOK", (Object)this.getSetToIrrecoverableOK()).add("unknownAddressOK", (Object)this.getUnknownAddressOK()).add("balanceDue", (Object)this.getBalanceDue()).add("balanceDueDebtRecovery", (Object)this.getBalanceDueDebtRecovery()).omitNullValues().toString();
    }
}

