/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_DEBT_RECOVERY_METHOD", indexes={@Index(columnList="name")})
public class DebtRecoveryMethod
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEBT_RECOVERY_METHOD_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEBT_RECOVERY_METHOD_SEQ", sequenceName="ACCOUNT_DEBT_RECOVERY_METHOD_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Method name")
    private String name;
    @HashKey
    @Widget(title="Code")
    @Column(unique=true)
    private String code;
    @Widget(title="Debt recovery method lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="debtRecoveryMethod", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DebtRecoveryMethodLine> debtRecoveryMethodLineList;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public DebtRecoveryMethod() {
    }

    public DebtRecoveryMethod(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<DebtRecoveryMethodLine> getDebtRecoveryMethodLineList() {
        return this.debtRecoveryMethodLineList;
    }

    public void setDebtRecoveryMethodLineList(List<DebtRecoveryMethodLine> debtRecoveryMethodLineList) {
        this.debtRecoveryMethodLineList = debtRecoveryMethodLineList;
    }

    public void addDebtRecoveryMethodLineListItem(DebtRecoveryMethodLine item) {
        if (this.getDebtRecoveryMethodLineList() == null) {
            this.setDebtRecoveryMethodLineList(new ArrayList<DebtRecoveryMethodLine>());
        }
        this.getDebtRecoveryMethodLineList().add(item);
        item.setDebtRecoveryMethod(this);
    }

    public void removeDebtRecoveryMethodLineListItem(DebtRecoveryMethodLine item) {
        if (this.getDebtRecoveryMethodLineList() == null) {
            return;
        }
        this.getDebtRecoveryMethodLineList().remove((Object)item);
    }

    public void clearDebtRecoveryMethodLineList() {
        if (this.getDebtRecoveryMethodLineList() != null) {
            this.getDebtRecoveryMethodLineList().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebtRecoveryMethod)) {
            return false;
        }
        DebtRecoveryMethod other = (DebtRecoveryMethod)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getCode(), other.getCode());
    }

    public int hashCode() {
        return Objects.hash(-71499671, this.getCode());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("code", (Object)this.getCode()).omitNullValues().toString();
    }
}

