/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.DebtRecoveryLevel;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.message.db.Template;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="ACCOUNT_DEBT_RECOVERY_METHOD_LINE", indexes={@Index(columnList="debt_recovery_level"), @Index(columnList="debtRecoveryLevelLabel"), @Index(columnList="debt_recovery_method")})
public class DebtRecoveryMethodLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DEBT_RECOVERY_METHOD_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_DEBT_RECOVERY_METHOD_LINE_SEQ", sequenceName="ACCOUNT_DEBT_RECOVERY_METHOD_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Level")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryLevel debtRecoveryLevel;
    @Widget(title="Label")
    @NameColumn
    private String debtRecoveryLevelLabel;
    @Widget(title="Standard trigger delay (days)")
    private Integer standardDeadline = 0;
    @Widget(title="Min. amount (\u20ac)")
    private BigDecimal minThreshold = BigDecimal.ZERO;
    @Widget(title="Message models")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Template> messageTemplateSet;
    @Widget(title="Manual validation")
    private Boolean manualValidationOk = Boolean.FALSE;
    @Widget(title="Debt recovery method")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private DebtRecoveryMethod debtRecoveryMethod;
    @Widget(title="Message on printing")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String printingMessage;
    @Widget(title="Specific mention on printing")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String specificPrintingMessage;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public DebtRecoveryLevel getDebtRecoveryLevel() {
        return this.debtRecoveryLevel;
    }

    public void setDebtRecoveryLevel(DebtRecoveryLevel debtRecoveryLevel) {
        this.debtRecoveryLevel = debtRecoveryLevel;
    }

    public String getDebtRecoveryLevelLabel() {
        return this.debtRecoveryLevelLabel;
    }

    public void setDebtRecoveryLevelLabel(String debtRecoveryLevelLabel) {
        this.debtRecoveryLevelLabel = debtRecoveryLevelLabel;
    }

    public Integer getStandardDeadline() {
        return this.standardDeadline == null ? 0 : this.standardDeadline;
    }

    public void setStandardDeadline(Integer standardDeadline) {
        this.standardDeadline = standardDeadline;
    }

    public BigDecimal getMinThreshold() {
        return this.minThreshold == null ? BigDecimal.ZERO : this.minThreshold;
    }

    public void setMinThreshold(BigDecimal minThreshold) {
        this.minThreshold = minThreshold;
    }

    public Set<Template> getMessageTemplateSet() {
        return this.messageTemplateSet;
    }

    public void setMessageTemplateSet(Set<Template> messageTemplateSet) {
        this.messageTemplateSet = messageTemplateSet;
    }

    public void addMessageTemplateSetItem(Template item) {
        if (this.getMessageTemplateSet() == null) {
            this.setMessageTemplateSet(new HashSet<Template>());
        }
        this.getMessageTemplateSet().add(item);
    }

    public void removeMessageTemplateSetItem(Template item) {
        if (this.getMessageTemplateSet() == null) {
            return;
        }
        this.getMessageTemplateSet().remove((Object)item);
    }

    public void clearMessageTemplateSet() {
        if (this.getMessageTemplateSet() != null) {
            this.getMessageTemplateSet().clear();
        }
    }

    public Boolean getManualValidationOk() {
        return this.manualValidationOk == null ? Boolean.FALSE : this.manualValidationOk;
    }

    public void setManualValidationOk(Boolean manualValidationOk) {
        this.manualValidationOk = manualValidationOk;
    }

    public DebtRecoveryMethod getDebtRecoveryMethod() {
        return this.debtRecoveryMethod;
    }

    public void setDebtRecoveryMethod(DebtRecoveryMethod debtRecoveryMethod) {
        this.debtRecoveryMethod = debtRecoveryMethod;
    }

    public String getPrintingMessage() {
        return this.printingMessage;
    }

    public void setPrintingMessage(String printingMessage) {
        this.printingMessage = printingMessage;
    }

    public String getSpecificPrintingMessage() {
        return this.specificPrintingMessage;
    }

    public void setSpecificPrintingMessage(String specificPrintingMessage) {
        this.specificPrintingMessage = specificPrintingMessage;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DebtRecoveryMethodLine)) {
            return false;
        }
        DebtRecoveryMethodLine other = (DebtRecoveryMethodLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("debtRecoveryLevelLabel", (Object)this.getDebtRecoveryLevelLabel()).add("standardDeadline", (Object)this.getStandardDeadline()).add("minThreshold", (Object)this.getMinThreshold()).add("manualValidationOk", (Object)this.getManualValidationOk()).omitNullValues().toString();
    }
}

