/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.Company;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.HashKey;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_DIRECT_DEBIT_MANAGEMENT", indexes={@Index(columnList="company")})
public class DirectDebitManagement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_DIRECT_DEBIT_MANAGEMENT_SEQ")
    @SequenceGenerator(name="ACCOUNT_DIRECT_DEBIT_MANAGEMENT_SEQ", sequenceName="ACCOUNT_DIRECT_DEBIT_MANAGEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @HashKey
    @Widget(title="Debit Nbr.")
    @NameColumn
    @Column(unique=true)
    private String debitNumber;
    @Widget(title="Debited schedule lines List")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="directDebitManagement", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<PaymentScheduleLine> paymentScheduleLineList;
    @Widget(title="Debited Invoices List")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Invoice> invoiceSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getDebitNumber() {
        return this.debitNumber;
    }

    public void setDebitNumber(String debitNumber) {
        this.debitNumber = debitNumber;
    }

    public List<PaymentScheduleLine> getPaymentScheduleLineList() {
        return this.paymentScheduleLineList;
    }

    public void setPaymentScheduleLineList(List<PaymentScheduleLine> paymentScheduleLineList) {
        this.paymentScheduleLineList = paymentScheduleLineList;
    }

    public void addPaymentScheduleLineListItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineList() == null) {
            this.setPaymentScheduleLineList(new ArrayList<PaymentScheduleLine>());
        }
        this.getPaymentScheduleLineList().add(item);
        item.setDirectDebitManagement(this);
    }

    public void removePaymentScheduleLineListItem(PaymentScheduleLine item) {
        if (this.getPaymentScheduleLineList() == null) {
            return;
        }
        this.getPaymentScheduleLineList().remove((Object)item);
    }

    public void clearPaymentScheduleLineList() {
        if (this.getPaymentScheduleLineList() != null) {
            this.getPaymentScheduleLineList().clear();
        }
    }

    public Set<Invoice> getInvoiceSet() {
        return this.invoiceSet;
    }

    public void setInvoiceSet(Set<Invoice> invoiceSet) {
        this.invoiceSet = invoiceSet;
    }

    public void addInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            this.setInvoiceSet(new HashSet<Invoice>());
        }
        this.getInvoiceSet().add(item);
    }

    public void removeInvoiceSetItem(Invoice item) {
        if (this.getInvoiceSet() == null) {
            return;
        }
        this.getInvoiceSet().remove((Object)item);
    }

    public void clearInvoiceSet() {
        if (this.getInvoiceSet() != null) {
            this.getInvoiceSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirectDebitManagement)) {
            return false;
        }
        DirectDebitManagement other = (DirectDebitManagement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return Objects.equals(this.getDebitNumber(), other.getDebitNumber());
    }

    public int hashCode() {
        return Objects.hash(-651120890, this.getDebitNumber());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("debitNumber", (Object)this.getDebitNumber()).omitNullValues().toString();
    }
}

